% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_glmer.R
\name{grouped_glmer}
\alias{grouped_glmer}
\title{Function to run generalized linear mixed-effects model (glmer) across multiple
grouping variables.}
\usage{
grouped_glmer(data, grouping.vars, ..., output = "tidy",
  tidy.args = list(conf.int = TRUE, conf.level = 0.95),
  augment.args = list())
}
\arguments{
\item{data}{Dataframe (or tibble) from which variables are to be taken.}

\item{grouping.vars}{Grouping variables.}

\item{...}{Arguments to function.

These dots support \link{tidy-dots} features.}

\item{output}{A character describing what output is expected. Two possible
options: \code{"tidy"} (default), which will return the results, or \code{"glance"},
which will return model summaries.}

\item{tidy.args}{A list of arguments to be used in the relevant \code{S3} method.}

\item{augment.args}{A list of arguments to be used in the relevant \code{S3} method.}
}
\value{
A tibble dataframe with tidy results from linear model or model
summaries.
}
\description{
Function to run generalized linear mixed-effects model (glmer) across multiple
grouping variables.
}
\examples{

# for reproducibility
set.seed(123)

# categorical outcome; binomial family
groupedstats::grouped_glmer(
  formula = Survived ~ Age + (Age | Class),
  family = stats::binomial(link = "probit"),
  data = dplyr::sample_frac(groupedstats::Titanic_full, size = 0.3),
  grouping.vars = Sex
)
}
\seealso{
grouped_lmer
}
\author{
Indrajeet Patil
}
