\name{gcFitSpline}
\Rdversion{1.1}
\alias{gcFitSpline}
\title{
Function to fit smoothed splines to growth data.
}
\description{
The function fits a smoothed spline to a set of growth data.
}
\usage{
gcFitSpline(time, data, gcID = "undefined",
            control = grofit.control())
}
\arguments{
  \item{time}{
Numeric vector containing the data for x-axes.
}
  \item{data}{
Numeric vector giving the growth values belonging to each element of \code{time}.
}
  \item{gcID}{
Vector (of any length) identifying the growth curve data.
}
  \item{control}{
Object of class \code{grofit.control} containing a list of options generated by the function \link{grofit.control}.
}
}
\value{
\item{raw.time}{Raw data given to the function; equivalent to \code{time}.}
\item{raw.data}{Raw data given to the function; equivalent to \code{data}.}
\item{gcID}{Vector (of any length) identifying the growth curve data.}
\item{fit.time}{Vector of fitted concentration values.}
\item{fit.data}{Vector of fitted growth values.}
\item{parameters}{List of estimated growth values from spline fit: \code{A}, maximum growth value; \code{mu}, maximum slope; \code{lambda}, lag-phase, \code{integral}, integral under growth curve.}
\item{parametersLowess}{List of estimated growth values from \code{\link{lowess}} fit: \code{A}, maximum growth value; \code{mu}, maximum slope; \code{lambda}, lag-phase.}
\item{spline}{\code{smooth.spline} object generated by \code{\link{smooth.spline}}.}
\item{reliable}{Logical, indicating wether the provided data is reliable (to be set manually).}
\item{fitFlag}{Logical, indicating wether a spline could fitted successfully to data.}
\item{control}{Object of class \code{grofit.control} containing list of options passed to the function as \code{control}.}
}
\examples{
x <- 1:30
y <- 1/(1+exp(0.5*(15-x)))+rnorm(30)/20
TestRun <- gcFitSpline(x,y)
print(summary(TestRun))
plot(TestRun)
}
\seealso{
\code{\link{gcFitModel}}, \code{\link{gcBootSpline}} , \code{\link{summary.gcFitSpline}}, \code{\link{plot.gcFitSpline}}
}
