% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{draw_n_person_sample}
\alias{draw_n_person_sample}
\title{Produce graphic for a single sample of n persons}
\usage{
draw_n_person_sample(prob, n, a = 10, ap = rep(1/length(a), length(a)))
}
\arguments{
\item{prob}{Probability to draw a construct from a certain category.}

\item{n}{Number of persons, i.e. grids to be sampled.}

\item{a}{Possible number of attributes sampled from.}

\item{ap}{Attribute probabilities, i.e. for each number of attributes given
in \code{a}.}
}
\description{
Produce graphic for a single sample of n persons
}
\examples{
draw_n_person_sample(dexp(1:30, rate = .05), n = 100, a = 10)
draw_n_person_sample(dexp(1:30, rate = .05), n = 100, a = 1:5, ap = 5:1)
}
\seealso{
Other Plotting: \code{\link{draw_multiple_n_persons_x_times}}
}

