% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{errorType}
\alias{errorType}
\title{Functions that extracts type of error from the model}
\usage{
errorType(object, ...)
}
\arguments{
\item{object}{Model estimated using one of the functions of smooth package.}

\item{...}{Currently nothing is accepted via ellipsis.}
}
\value{
Either \code{"A"} for additive error or \code{"M"} for multiplicative.
All the other functions return strings of character.
}
\description{
This function allows extracting error type from any model.
}
\details{
\code{errorType} extracts the type of error from the model
(either additive or multiplicative).
}
\examples{

xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rnorm(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")
ourModel <- alm(y~x1+x2,as.data.frame(xreg))

errorType(ourModel)

}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
