% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmCombine.R
\name{lmCombine}
\alias{lmCombine}
\alias{combine}
\alias{combiner}
\title{Combine regressions based on information criteria}
\usage{
lmCombine(data, ic = c("AICc", "AIC", "BIC", "BICc"),
  bruteForce = FALSE, silent = TRUE, distribution = c("dnorm",
  "dfnorm", "dlnorm", "dlaplace", "ds", "dchisq", "dlogis", "plogis",
  "pnorm"))
}
\arguments{
\item{data}{Data frame containing dependent variable in the first column and
the others in the rest.}

\item{ic}{Information criterion to use.}

\item{bruteForce}{If \code{TRUE}, then all the possible models are generated
and combined. Otherwise the best model is found and then models around that
one are produced and then combined.}

\item{silent}{If \code{FALSE}, then nothing is silent, everything is printed
out. \code{TRUE} means that nothing is produced.}

\item{distribution}{Distribution to pass to \code{alm()}.}
}
\value{
Function returns \code{model} - the final model of the class
"greyboxC". The list of variables:
\itemize{
\item coefficients - combined parameters of the model,
\item se - combined standard errors of the parameters of the model,
\item actuals - actual values of the response variable,
\item fitted.values - the fitted values,
\item residuals - residual of the model,
\item distribution - distribution used in the estimation,
\item logLik - combined log-likelihood of the model,
\item IC - the values of the combined information criterion,
\item df.residual - number of degrees of freedom of the residuals of
the combined model,
\item df - number of degrees of freedom of the combined model,
\item importance - importance of the parameters,
\item call - call used in the function,
\item rank - rank of the combined model,
\item data - the data used in the model,
\item mu - the location value of the distribution.
}
}
\description{
Function combines parameters of linear regressions of the first variable
on all the other provided data.
}
\details{
The algorithm uses alm() to fit different models and then combines the models
based on the selected IC.
}
\examples{

### Simple example
xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rnorm(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")
inSample <- xreg[1:80,]
outSample <- xreg[-c(1:80),]
# Combine all the possible models
ourModel <- lmCombine(inSample,bruteForce=TRUE)
predict(ourModel,outSample)
plot(predict(ourModel,outSample))

### Fat regression example
xreg <- matrix(rnorm(5000,10,3),50,100)
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rnorm(50,0,3),xreg,rnorm(50,300,10))
colnames(xreg) <- c("y",paste0("x",c(1:100)),"Noise")
inSample <- xreg[1:40,]
outSample <- xreg[-c(1:40),]
# Combine only the models close to the optimal
ourModel <- lmCombine(inSample,ic="BICc",bruteForce=FALSE)
summary(ourModel)
plot(predict(ourModel,outSample))

}
\references{
\itemize{
\item Burnham Kenneth P. and Anderson David R. (2002). Model Selection
and Multimodel Inference. A Practical Information-Theoretic Approach.
Springer-Verlag New York. DOI: [10.1007/b97636](http://dx.doi.org/10.1007/b97636).
}
}
\seealso{
\code{\link[stats]{step}, \link[greybox]{xregExpander},
\link[greybox]{stepwise}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
