% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{abs-conn}
\alias{abs-conn}
\alias{content2series_id}
\alias{download_data}
\alias{when_last_updated}
\title{ABS Connections}
\usage{
content2series_id(
  broad_cat = c("cpi", "lfi", "wpi"),
  adjustment = c("original", "seasonal", "trend", "trimmed-mean", "monthly-original",
    "monthly-seasonal", "monthly-excl-volatile")
)

download_data(series_id = NULL)

when_last_updated()
}
\arguments{
\item{broad_cat, adjustment}{Definitions to identify the Series ID. If any
are multiple, the result is of the cartesian join, \strong{not} the
component-wise values.}

\item{series_id}{The Series ID desired. For \code{download_data}, if \code{NULL},
the default, downloads all files required.}
}
\value{
\describe{
\item{\code{content2series_id}}{A character vector, the Series ID identified
by `broad_cat` and `adjustment`}
\item{\code{download_data}}{Called for its side-effect, downloading the
data required. If successful, returns zero.}
\item{\code{when_last_updated}}{The date the downloaded data was last retrieved, or
the string \code{"Never"} if the file does not exist.}
}
}
\description{
The package uses the catalogue mirrored at \url{https://github.com/HughParsonage/ABS-Catalogue}.
These functions expose the guts of the package's method to connect to this mirror.

Each inflator, plus the 'adjustment', is associated with an ABS Series ID.
}
