% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpi_inflator.R
\name{cpi_inflator}
\alias{cpi_inflator}
\title{CPI inflator}
\usage{
cpi_inflator(
  from = NULL,
  to = NULL,
  series = c("seasonal", "original", "trimmed.mean", "monthly-original",
    "monthly-seasonal", "monthly-excl-volatile"),
  fy_month = 3L,
  x = NULL,
  check = 1L,
  nThread = getOption("grattanInflators.nThread", 1L)
)
}
\arguments{
\item{from, to}{Times for which the inflator is desired. If \code{NULL}, a date
range close to the previous year is used.}

\item{series}{Which CPI series to use.}

\item{fy_month}{An integer 1-12, the month to be used for
years and financial years in \code{from} or \code{to}. Since the CPI is a
quarterly series, specifying a year is ambiguous. For
financial years, the month is the month of the financial year,
so for example \code{fy_month = 9} and "2015-16" means Sep-2015,
while \code{fy_month = 6} means Jun-2016.}

\item{x}{(Advanced) A vector that will be inflated in-place. If \code{NULL},
the default, the return vector is simply the inflation factor for `from`.}

\item{check}{\code{integer(1)} If \code{0L}, no checks are performed, and
clearly invalid inputs result in \code{NA} in the output. If \code{check = 1L}
an error is performed for bad input; \code{check = 2L} is more thorough.}

\item{nThread}{Number of threads to use.}
}
\value{
If `x` is `NULL`, the default, a numeric vector matching the lengths of `from`
and `to` equal to the inflators by which nominal prices dated `from` must be
multiplied so that they are in `to` real terms.

If `x` is numeric, it is taken to be prices dated `from` and the value returned
is `x` in `to` real terms.
}
\description{
CPI inflator
}
\examples{
cpi_inflator("2015-16", "2016-17")
cpi_inflator("2015-01-01", "2016-01-01")

}
