% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentially_uprate_wage.R
\name{differentially_uprate_wage}
\alias{differentially_uprate_wage}
\title{Differential uprating}
\usage{
differentially_uprate_wage(wage = 1, from_fy, to_fy, ...)
}
\arguments{
\item{wage}{A numeric vector to be uprated.}

\item{from_fy}{The financial year contemporaneous to wage, which must be a financial year of an available sample file -- in particular, not after 2013-14.}

\item{to_fy}{The target of the uprating. Passed to \code{\link{wage_inflator}}.}

\item{...}{Other arguments passed \code{\link{wage_inflator}}.}
}
\value{
The vector \code{wage} differentially uprated to \code{to_fy}.
}
\description{
Apply differential uprating to projections of the \code{Sw_amt} variable.
}
\details{
See \code{vignette("differential-uprating")}.
}
\examples{
ws <- c(20e3, 50e3, 100e3)
from <- "2013-14"
to <- "2016-17"
differentially_uprate_wage(ws, from, to)
differentially_uprate_wage(ws, from, to) / wage_inflator(ws, from, to)

# Use a wage series:
if (requireNamespace("taxstats", quietly = TRUE)) {
  library(data.table)
  library(taxstats)
  WageGrowth <- data.table(fy_year = c("2017-18", "2018-19"),
                           r = c(0.0, 0.1))
  Wage201314 <- sample_file_1314[["Sw_amt"]]
  
  data.table(Wage_201314 = Wage201314,
             Wage_201819 = 
               differentially_uprate_wage(Wage201314, 
                                          from_fy = "2013-14",
                                          to_fy = "2018-19",
                                          wage.series = WageGrowth))
}
}
\author{
Hugh Parsonage and William Young
}
