% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_grouper.R
\name{age_grouper}
\alias{age_grouper}
\title{Age grouper}
\usage{
age_grouper(age, interval = 10, min_age = 25, max_age = 75,
  breaks = NULL, labels = NULL)
}
\arguments{
\item{age}{A numeric age (in years).}

\item{interval}{How big should the age range be. 25-34 means interval = 10.}

\item{min_age}{What is the upper bound of the lowest bracket? (\code{min_age = 25} means 'Under 25' will be the lowest bracket.)}

\item{max_age}{What is the lower bound of the highest bracket? (\code{max_age = 75} means '75+' will be the bracket.)}

\item{breaks}{Specify breaks manually.}

\item{labels}{Specify the labels manually.}
}
\value{
An ordered factor giving age ranges (separated by hyphens) as specified.
}
\description{
Age grouper
}
\examples{
age_grouper(42)
age_grouper(42, interval = 5, min_age = 20, max_age = 60)
}
