% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_ts.R
\name{generate_ts}
\alias{generate_ts}
\title{Generate time series from random parameter spaces of the mixture autoregressive (MAR) models.}
\usage{
generate_ts(n.ts = 1, freq = 1, nComp = NULL, n = 120)
}
\arguments{
\item{n.ts}{number of time series to be generated.}

\item{freq}{seasonal period of the time series to be generated.}

\item{nComp}{number of mixing components when simulating time series using MAR models.}

\item{n}{length of the generated time series.}
}
\value{
A list of time series together with the SARIMA coefficients used in each mixing
component and the corresponding mixing weights.
}
\description{
Generate time series from random parameter spaces of the mixture autoregressive (MAR) models.
}
\examples{
x <- generate_ts(n.ts = 2, freq = 12, nComp = 2, n = 120)
x$N1$pars
forecast::autoplot(x$N1$x)
}
\references{
Wong, CS & WK Li (2000).
}
\author{
Yanfei Kang and Feng Li
}
