% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_smooth.R
\name{evaluate_smooth}
\alias{evaluate_smooth}
\alias{evaluate_smooth.gam}
\alias{evaluate_smooth.gamm}
\alias{evaluate_parametric_term}
\alias{evaluate_parametric_term.gam}
\title{Evaluate a smooth}
\usage{
evaluate_smooth(object, ...)

\method{evaluate_smooth}{gam}(object, smooth, n = 100, newdata = NULL,
  unconditional = FALSE, overall_uncertainty = TRUE, dist = 0.1, ...)

\method{evaluate_smooth}{gamm}(object, ...)

evaluate_parametric_term(object, ...)

\method{evaluate_parametric_term}{gam}(object, term,
  unconditional = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{"gam"} or \code{"gamm"}.}

\item{...}{arguments passed to other methods.}

\item{smooth}{character; a single smooth to evaluate.}

\item{n}{numeric; the number of points over the range of the covariate at
which to evaluate the smooth.}

\item{newdata}{a vector or data frame of points at which to evaluate the
smooth.}

\item{unconditional}{logical; should confidence intervals include the
uncertainty due to smoothness selection? If \code{TRUE}, the corrected Bayesian
covariance matrix will be used.}

\item{overall_uncertainty}{logical; should the uncertainty in the model
constant term be included in the standard error of the evaluate values of
the smooth?}

\item{dist}{numeric; if greater than 0, this is used to determine when
a location is too far from data to be plotted when plotting 2-D smooths.
The data are scaled into the unit square before deciding what to exclude,
and \code{dist} is a distance within the unit square. See
\code{\link[mgcv:exclude.too.far]{mgcv::exclude.too.far()}} for further details.}

\item{term}{character; which parametric term whose effects are evaulated}
}
\value{
A data frame, which is of class \code{"evaluated_1d_smooth"} or
\code{evaluated_2d_smooth}, which inherit from classes \code{"evaluated_smooth"}
and \code{"data.frame"}.
}
\description{
Evaluate a smooth at a grid of evenly spaced value over the range of the
covariate associated with the smooth. Alternatively, a set of points at
which the smooth should be evaluated can be supplied.
}
\examples{
library("mgcv")
\dontshow{
set.seed(2)
op <- options(cli.unicode = FALSE, digits = 6)
}
dat <- gamSim(1, n = 400, dist = "normal", scale = 2)
m1 <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

evaluate_smooth(m1, "s(x1)")

## 2d example
set.seed(2)
dat <- gamSim(2, n = 1000, dist = "normal", scale = 1)
m2 <- gam(y ~ s(x, z, k = 30), data = dat$data, method = "REML")

evaluate_smooth(m2, "s(x,z)", n = 100)
\dontshow{options(op)}
}
