% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period.R
\name{new_period}
\alias{new_period}
\alias{is_period}
\title{Minimal constructor for a period object}
\usage{
new_period(x = integer(), n = 1L, offset = 0L)

is_period(xx)
}
\arguments{
\item{x}{\verb{[integer]}

Vector representing the number of periods since the Unix Epoch (1970-01-01)
and a specified offset.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{n}{\verb{[integer]}

Number of days that are being grouped by.}

\item{offset}{\verb{[integer]}

Value you wish to start counting groups from relative to the Unix Epoch.}

\item{xx}{\R object.}
}
\value{
A \verb{<grates_period>} object.
}
\description{
\code{new_period()} is a constructor for \verb{<grates_period>} objects aimed at
developers.
}
\details{
\code{grates_period} objects are stored as the integer number, starting at 0L, of
periods since the Unix Epoch (1970-01-01) and a specified offset. Here
periods are taken to mean groupings of \code{n} consecutive days.

For storage and calculation purposes, \code{offset} is scaled relative to \code{n}.
I.e. \code{offset <- offset \%\% n} and values of \code{x} stored relative to this scaled
offset.
}
\examples{
new_period(1:10)

}
