% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphpcor.R
\name{hessian.graphpcor}
\alias{hessian.graphpcor}
\title{Evaluate the hessian of the KLD for a \code{graphpcor}
correlation model around a base model.}
\usage{
\method{hessian}{graphpcor}(func, x, method = "Richardson", method.args = list(), ...)
}
\arguments{
\item{func}{model definition of a graphical model.
This can be either a matrix or a 'graphpcor'.}

\item{x}{either a reference correlation matrix
or a numeric vector with the parameters for the
reference 'graphpcor' model.}

\item{method}{see \code{\link[numDeriv:hessian]{numDeriv::hessian()}}}

\item{method.args}{see \code{\link[numDeriv:hessian]{numDeriv::hessian()}}}

\item{...}{use to pass the decomposition method,
as a character to specify which one is to be used
to compute H^0.5 and H^(1/2).}
}
\value{
list containing the hessian,
its 'square root', inverse 'square root' along
with the decomposition used
}
\description{
Evaluate the hessian of the KLD for a \code{graphpcor}
correlation model around a base model.
}
