% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_node_compar.R
\name{graph_node_compar}
\alias{graph_node_compar}
\title{Compare the local properties of the nodes from two graphs}
\usage{
graph_node_compar(
  x,
  y,
  metrics = c("siw", "siw"),
  method = "spearman",
  weight = TRUE,
  test = TRUE
)
}
\arguments{
\item{x}{An object of class \code{igraph}.
Its nodes must have the same names as in graph \code{y}.}

\item{y}{An object of class \code{igraph}.
Its nodes must have the same names as in graph \code{x}.}

\item{metrics}{Two-elements character vector specifying the graph-theoretic
metrics computed at the node-level in the graphs or the nodes' attribute
values to be correlated to these metrics.
Graph-theoretic metrics can be:
\itemize{
\item{Degree (\code{metrics = c("deg", ...)})}
\item{Closeness centrality index (\code{metrics = c("close",...)})}
\item{Betweenness centrality index (\code{metrics = c("btw",...)})}
\item{Strength (sum of the weights of the links connected to a node)
(\code{metrics = c("str",...)})}
\item{Sum of the inverse weights of the links connected to a
node (\code{metrics = c("siw", ...)}, default)}
\item{Mean of the inverse weights of the links connected to a
node (\code{metrics = c("miw", ...)})}
}
Nodes' attributes must have the same names as in the \code{igraph} object,
and must refer to an attribute with numerical values.
The vector \code{metrics} is composed of two character values.
When a nodes' attribute has the same name as a metric computable from the
graph, nodes' attributes are given priority.}

\item{method}{A character string indicating which correlation coefficient
is to be computed (\code{"pearson"}, \code{"kendall"} or
\code{"spearman"} (default)).}

\item{weight}{Logical which indicates whether the links are weighted during
the calculation of the centrality indices betweenness and closeness.
(default: \code{weight = TRUE}). Links' weights are interpreted as distances
when computing the shortest paths. They should then be inversely proportional
to the strength of the relationship between nodes (e.g. to fluxes).}

\item{test}{Logical. Should significance testing be performed?
(default = TRUE)}
}
\value{
A \code{list} summarizing the correlation analysis.
}
\description{
The function computes a correlation coefficient between the
graph-theoretic metric values computed at the node-level in two graphs
sharing the same nodes. It allows to assess whether the connectivity
properties of the nodes in one graph are similar to that of the same nodes
in the other graph. Alternatively, the correlation is computed between
a graph-theoretic metric values and the values of an attribute associated
to the nodes of a graph.
}
\details{
The correlation coefficients between the metrics can be computed
in different ways, as initial assumptions (e.g. linear relationship) are
rarely verified. Pearson's r, Spearman's rho and Kendall's tau can be
computed (from function \code{\link[stats]{cor}}).
When \code{x} is similar to \code{y}, then the correlation is computed
between two metrics characterizing the nodes of the same graph.
}
\examples{
data(data_ex_genind)
data(pts_pop_ex)
mat_dist <- suppressWarnings(graph4lg::mat_geo_dist(data = pts_pop_ex,
      ID = "ID",
      x = "x",
      y = "y"))
mat_dist <- mat_dist[order(as.character(row.names(mat_dist))),
                      order(as.character(colnames(mat_dist)))]
graph_obs <- gen_graph_thr(mat_w = mat_dist, mat_thr = mat_dist,
                           thr = 9500, mode = "larger")
mat_gen <- mat_gen_dist(x = data_ex_genind, dist = "DPS")
graph_pred <- gen_graph_topo(mat_w = mat_gen, mat_topo = mat_dist,
                            topo = "gabriel")
res_cor <- graph_node_compar(x = graph_obs, y = graph_pred,
                             metrics = c("siw", "siw"), method = "spearman",
                             test = TRUE, weight = TRUE)
}
\author{
P. Savary
}
