% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffexp.R
\name{Pairwise}
\alias{Pairwise}
\title{Log2 fold changes and Wald tests for differential expression}
\usage{
Pairwise(
  data,
  name.prefix = mode,
  contrasts,
  LFC.fun = lfc::PsiLFC,
  slot = "count",
  mode = "total",
  normalization = mode,
  genes = NULL,
  verbose = FALSE
)
}
\arguments{
\item{data}{the grandR object}

\item{name.prefix}{the prefix for the new analysis name; a dot and the column names of the contrast matrix are appended; can be NULL (then only the contrast matrix names are used)}

\item{contrasts}{contrast matrix that defines all pairwise comparisons, generated using \link{GetContrasts}}

\item{LFC.fun}{function to compute log fold changes (default: \link[lfc]{PsiLFC}, other viable option: \link[lfc]{NormLFC})}

\item{slot}{the slot of the grandR object to take the data from; should contain counts!}

\item{mode}{compute LFCs for "total", "new", or "old" RNA}

\item{normalization}{normalize on "total", "new", or "old" (see details)}

\item{genes}{restrict analysis to these genes; NULL means all genes}

\item{verbose}{print status messages?}
}
\value{
a new grandR object including a new analysis table. The columns of the new analysis table are
 \item{"M"}{the base mean}
 \item{"S"}{the log2FoldChange divided by lfcSE}
 \item{"P"}{the Wald test P value}
 \item{"Q"}{same as P but Benjamini-Hochberg multiple testing corrected}
 \item{"LFC"}{the log2 fold change}
}
\description{
This function is a shortcut for first calling \link{PairwiseDESeq2} and then \link{LFC}.
}
\details{
Both \link[lfc]{PsiLFC} and  \link[lfc]{NormLFC}) by default perform normalization by subtracting the median log2 fold change from all log2 fold changes.
When computing LFCs of new RNA, it might be sensible to normalize w.r.t. to total RNA, i.e. subtract the median log2 fold change of total RNA from all the log2 fold change of new RNA.
This can be accomplished by setting mode to "new", and normalization to "total"!

Normalization can also be a mode.slot! Importantly, do not specify a slot containing normalized values, but specify a slot of unnormalized values
(which are used to compute the size factors for normalization!) Can also be a numeric vector of size factors with the same length as the data as columns.
Then each value is divided by the corresponding size factor entry.
}
\seealso{
\link{PairwiseDESeq2},\link{GetContrasts}
}
\concept{diffexp}
