% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{GetData}
\alias{GetData}
\title{Obtain a tidy table of values for a gene or a small set of genes}
\usage{
GetData(
  data,
  mode.slot = DefaultSlot(data),
  columns = NULL,
  genes = Genes(data),
  by.rows = FALSE,
  coldata = TRUE,
  ntr.na = TRUE,
  name.by = "Symbol"
)
}
\arguments{
\item{data}{A grandR object}

\item{mode.slot}{Which kind of data to access (see details)}

\item{columns}{A vector of columns (see details); all condition/cell names if NULL}

\item{genes}{Restrict the output table to the given genes (this typically is a single gene, or very few genes)}

\item{by.rows}{if TRUE, add rows if there are multiple genes / mode.slots; otherwise, additional columns are appended}

\item{coldata}{Should the table contain the \link{Coldata} values as well (at the beginning)?}

\item{ntr.na}{For columns representing a 4sU naive sample, should mode.slot \emph{ntr},\emph{new.count} and \emph{old.count} be 0,0 and count (ntr.na=FALSE; can be any other slot than count) or NA,NA and NA (ntr.na=TRUE)}

\item{name.by}{A column name of \link{Coldata}(data). This is used as the colnames of the output table}
}
\value{
A data frame containing the desired values
}
\description{
This is the main function to access slot data data from a particular gene
(or a small set of genes) as a tidy table. If data for all genes
must be retrieved (as a large matrix), use the \code{\link{GetTable}}
function. For analysis results, use the \code{\link{GetAnalysisTable}} function.
}
\details{
To refer to data slots, the mode.slot syntax can be used: Each name is either a data slot, or one of (new,old,total) followed by a dot followed by a slot. For new or old, the data slot value is multiplied by ntr or 1-ntr. This can be used e.g. to obtain the \emph{new counts}.

If only one mode.slot and one gene is given, the output table contains one column (and potentially columns from \link{Coldata}) named \emph{Value}. If one gene and multiple mode.slots are given, the columns are named according to the mode.slots. If one mode.slot and multiple genes are given, the columns are named according to the genes. If multiple genes and mode.slots are given, columns are named gene.mode.slot.

If by.rows=TRUE, the table is molten such that each row contains only one value (for one of the genes and for one of the mode.slots). If only one gene and one mode.slot is given, melting does not have an effect.

Columns can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
The expression is evaluated in an environment havin the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently build a logical vector (e.g., columns=Condition=="x").
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Cell",Design$dur.4sU,Design$Replicate))
GetData(sars,mode.slot="ntr",gene="MYC")
# one gene, one mode.slot
GetData(sars,mode.slot=c("count","ntr"),gene="MYC",coldata = FALSE)
# one gene, multiple mode.slots
GetData(sars,mode.slot=c("count","ntr"),gene=c("SRSF6","MYC"),by.rows=TRUE)
# multiple genes, multiple mode.slots, by rows

}
\seealso{
\link{GetTable},\link{GetAnalysisTable},\link{DefaultSlot},\link{Genes}
}
\concept{data}
