% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_grafify_c.R
\name{scale_color_grafify_c}
\alias{scale_color_grafify_c}
\title{Scale_color continuous scheme}
\usage{
scale_color_grafify_c(reverse = FALSE, ...)
}
\arguments{
\item{reverse}{Whether the color order should be reversed.}

\item{...}{Additional parameters for \code{scale_fill} or \code{scale_color}.}
}
\value{
ggplot scale_fill function for continuous colours.
}
\description{
\code{grafify} internally includes color-blind compatible schemes for fill and color/color aesthetics.
Note that this scheme is \strong{only} for continuous variables and has one palette (\code{yellow_conti}) \href{http://personal.sron.nl/~pault/#sec:sequential}{modified from} the YlOrBr scheme from RColorBrewer.
}
\details{
Colour palettes available are as follows:

\if{html}{\out{<div style="text-align: center">}\figure{grafify_palettesv020.jpg}{options: style="width:750px;max-width:70\%;"}\out{</div>}}

Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
}
\examples{
#basic usage on mtcars data with x and y quantitative axes
ggplot(mtcars, aes(x = mpg, y = disp))+
geom_point(aes(color= disp), size = 3)+
scale_color_grafify_c()

}
