% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{accuracy}
\alias{accuracy}
\title{Accuracy Estimates for Predictions}
\usage{
accuracy(predRes)
}
\arguments{
\item{predRes}{object of class \code{GPPMPred} as obtained by \code{\link{predict.GPPM}}}
}
\value{
accuracy estimates in the form of the mean squared error (MSE), the negative log-predictive probability (nLPP), and the sum squared error (SSE)
}
\description{
Estimate the accuracy based on predictions.
}
\examples{
\donttest{
data("demoLGCM")
#remove all measurements from person 1 and the first form person 2
predIdx <- c(which(demoLGCM$ID==1),which(demoLGCM$ID==2)[1])
fitDemoLGCM <- demoLGCM[setdiff(1:nrow(demoLGCM),predIdx),]

lgcm <- gppm('muI+muS*t','varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma',
             fitDemoLGCM,'ID','y')
lgcm <- fit(lgcm)
predRes <- predict(lgcm,demoLGCM[predIdx,])
accEsts <- accuracy(predRes)
accEsts$MSE #mean squared error
accEsts$nLPP #negative log-predictive probability
}
}
