% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restart.R
\name{gpg_restart}
\alias{gpg_restart}
\alias{gpg_version}
\alias{gpg_info}
\alias{gpg_options}
\title{Manage the GPG engine}
\usage{
gpg_restart(home = NULL, path = NULL, debug = "none", silent = FALSE)

gpg_version(silent = FALSE)

gpg_info()

gpg_options()
}
\arguments{
\item{home}{path to your GPG configuration directory (including keyrings)}

\item{path}{location of \code{gpg} or \code{gpg2} or \code{gpgconf} or (on windows) \code{gpgme-w32spawn.exe}}

\item{debug}{debugging level, integer between 1 and 9}

\item{silent}{suppress output of \code{gpg --version}}
}
\description{
Use \code{gpg_restart()} to find the \code{gpg} program and home directory (which contains
configuration and keychains). Usually the default should be fine and you
do not need to run this function manually.
}
\details{
Use \code{gpg_info()} to get your current engine settings. The \code{gpg_version()} function
simply calls \code{gpg --version} to see some verbose output about the \code{gpg} executable.

\code{gpg_options} reads options in the GnuPG configuration file, which is stored by
default in \code{~/.gnupg/gpg.conf}. Note that changing options might affect
other software using GnuPG.
}
\examples{
gpg_version()
gpg_info()
}
