% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readRDS.gpb.Booster.R
\name{readRDS.gpb.Booster}
\alias{readRDS.gpb.Booster}
\title{readRDS for \code{gpb.Booster} models}
\usage{
readRDS.gpb.Booster(file, refhook = NULL)
}
\arguments{
\item{file}{a connection or the name of the file where the R object is saved to or read from.}

\item{refhook}{a hook function for handling reference objects.}
}
\value{
\code{gpb.Booster}
}
\description{
Attempts to load a model stored in a \code{.rds} file, using \code{\link[base]{readRDS}}
}
\examples{
\donttest{
library(gpboost)
data(agaricus.train, package = "gpboost")
train <- agaricus.train
dtrain <- gpb.Dataset(train$data, label = train$label)
data(agaricus.test, package = "gpboost")
test <- agaricus.test
dtest <- gpb.Dataset.create.valid(dtrain, test$data, label = test$label)
params <- list(objective = "regression", metric = "l2")
valids <- list(test = dtest)
model <- gpb.train(
  params = params
  , data = dtrain
  , nrounds = 10L
  , valids = valids
  , min_data = 1L
  , learning_rate = 1.0
  , early_stopping_rounds = 5L
)
model_file <- tempfile(fileext = ".rds")
saveRDS.gpb.Booster(model, model_file)
new_model <- readRDS.gpb.Booster(model_file)
}
}
