% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_tricot.R
\name{rank_tricot}
\alias{rank_tricot}
\title{Build Plackett-Luce rankings from tricot dataset}
\usage{
rank_tricot(data, items, input, group = FALSE, additional.rank = NULL, ...)
}
\arguments{
\item{data}{a data.frame with columns specified by items and input values}

\item{items}{a character or numerical vector for indexing the column(s) 
containing the item names in \code{data}}

\item{input}{a character or numerical vector for indexing the column(s) 
containing the values in \code{data} to be ranked}

\item{group}{logical, if \code{TRUE} return an object of class "grouped_rankings"}

\item{additional.rank}{optional, a data frame for the comparisons between 
tricot items and the local item}

\item{...}{additional arguments passed to methods. See details}
}
\value{
a PlackettLuce "rankings" object, which is a matrix of dense rankings
}
\description{
Create an object of class "rankings" from tricot data. Tricot stands 
for "triadic comparison of technologies". Is a methodology to carry out 
large agronomic field experiments allowing the comparison between many 
alternative technologies, in many different environments. Each participant
evaluates a set of three randomised technologies from a larger set. A 
comparison with a local item can be added as additional rankings with the 
argument \code{additional.rank}.
}
\details{
full.output: logical, to return a list with a "rankings", 
a "grouped_rankings" and the ordered items
}
\examples{

# using breadwheat data
data("breadwheat", package = "gosset")

# convert the tricot rankings from breadwheat data
# into a object of class 'rankings' from PlackettLuce
R <- rank_tricot(data = breadwheat,
                 items = c("variety_a","variety_b","variety_c"),
                 input = c("overall_best","overall_worst"))
                 
############################################################
  
# beans data where each observer compares 3 varieties randomly distributed
# from a list of 11 and additionally compares these 3 varieties
# with their local variety
library("PlackettLuce")
data("beans", package = "PlackettLuce")

# first build rankings with only tricot items
# and return an object of class 'rankings'
R <- rank_tricot(data = beans,
                 items = c(1:3),
                 input = c(4:5))
head(R)

############################################################

# pass the comparison with local item as an additional rankings, then
# each of the 3 varieties are compared separately with the local item
# and return an object of class grouped_rankings
G <- rank_tricot(data = beans,
                 items = c(1:3),
                 input = c(4:5),
                 group = TRUE,
                 additional.rank = beans[c(6:8)])

head(G)

}
\references{
van Etten J., et al. (2016). Experimental Agriculture, 55(S1), 275–296.
\doi{https://doi.org/10.1017/S0014479716000739}
}
\seealso{
\code{\link[PlackettLuce]{rankings}}, \code{\link{breadwheat}}

Other rank functions: 
\code{\link{rank_binomial}()},
\code{\link{rank_numeric}()},
\code{\link{rank_paircomp}()}
}
\author{
Kauê de Sousa and Jacob van Etten, with ideas from Heather Turner
}
\concept{rank functions}
