% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layer_circle.R
\name{add_circles}
\alias{add_circles}
\title{Add circle}
\usage{
add_circles(map, data = get_map_data(map), id = NULL, lat = NULL,
  lon = NULL, polyline = NULL, radius = NULL, editable = NULL,
  draggable = NULL, stroke_colour = NULL, stroke_opacity = NULL,
  stroke_weight = NULL, fill_colour = NULL, fill_opacity = NULL,
  mouse_over = NULL, mouse_over_group = NULL, info_window = NULL,
  layer_id = NULL, update_map_view = TRUE, z_index = NULL, digits = 4,
  palette = NULL, legend = F, legend_options = NULL, load_interval = 0)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{data}{data frame containing at least two columns, one specifying the
latitude coordinates, and the other specifying the longitude. If Null, the
data passed into \code{google_map()} will be used.}

\item{id}{string specifying the column containing an identifier for a shape}

\item{lat}{string specifying the column of \code{data} containing the 'latitude'
coordinates. If left NULL, a best-guess will be made}

\item{lon}{string specifying the column of \code{data} containing the 'longitude'
coordinates. If left NULL, a best-guess will be made}

\item{polyline}{string specifying the column of \code{data} containing the encoded polyline.
For circles and markers the encoded string will represent a single point.}

\item{radius}{either a string specifying the column of \code{data} containing the
radius of each circle, OR a numeric value specifying the radius of all the circles
(radius is expressed in metres)}

\item{editable}{string specifying the column of \code{data} defining if the polygon
is 'editable' (either TRUE or FALSE)}

\item{draggable}{string specifying the column of \code{data} defining if
the polygon is 'draggable'. The column of data should be logical (either TRUE or FALSE)}

\item{stroke_colour}{either a string specifying the column of \code{data} containing
the stroke colour of each shape, or a valid hexadecimal numeric HTML style to
be applied to all the shapes}

\item{stroke_opacity}{either a string specifying the column of \code{data} containing
the stroke opacity of each shape, or a value between 0 and 1 that will be
applied to all the shapes}

\item{stroke_weight}{either a string specifying the column of \code{data} containing
the stroke weight of each shape, or a number indicating the width of pixels
in the line to be applied to all the shapes}

\item{fill_colour}{either a string specifying the column of \code{data} containing
the fill colour of each shape, or a valid hexadecimal numeric HTML style to
be applied to all the shapes}

\item{fill_opacity}{either a string specifying the column of \code{data} containing
the fill opacity of each shape, or a value between 0 and 1 that will be applied
to all the shapes}

\item{mouse_over}{string specifying the column of data to display when the
mouse rolls over the shape}

\item{mouse_over_group}{string specifying the column of data specifying which
groups of shapes to highlight on mouseover}

\item{info_window}{string specifying the column of data to display in an info
window when a shape is clicked.}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers for when using any \code{update_} function, and
for separating legends.}

\item{update_map_view}{logical specifying if the map should re-centre according to
the circles}

\item{z_index}{single value specifying where the circles appear in the layering
of the map objects. Layers with a higher \code{z_index} appear on top of those with
a lower \code{z_index}. See details.}

\item{digits}{integer. Use this parameter to specify how many digits (decimal places)
should be used for the latitude / longitude coordinates.}

\item{palette}{a function, or list of functions, that generates hex colours
given a single number as an input. See details.}

\item{legend}{either a logical indiciating if the legend(s) should be displayed, or
a named list indicating which colour attributes should be included in the legend.}

\item{legend_options}{A list of options for controlling the legend.}

\item{load_interval}{time in miliseconds to wait between plotting each shape}
}
\description{
Add circles to a google map
}
\details{
\code{z_index} values define the order in which objects appear on the map.
Those with a higher value appear on top of those with a lower value. The default
order of objects is (1 being underneath all other objects)

\itemize{
  \item{1. Polygon}
  \item{2. Rectangle}
  \item{3. Polyline}
  \item{4. Circle}
}

Markers are always the top layer
}
\section{palette}{


The \code{palette} is used to specify the colours that will map to variables.
You can specify a single function to map to all variables, or a named list
that specifies a separate function to map to each variable. The elements must
be named either \code{fill_colour} or \code{stroke_colour}, and their values
are the colour generating functions. The default is \code{viridisLite::viridis}

The \code{legend_options} can be used to control the appearance of the legend.
This should be a named list, where the names are one of
\itemize{
  \item{position - one of \code{c("TOP_LEFT", "TOP_CENTER", "TOP_RIGHT", "RIGHT_TOP",
  "RIGHT_CENTER", "RIGHT_BOTTOM", "BOTTOM_RIGHT", "BOTTOM_CENTER", "BOTTOM_LEFT",
  "LEFT_BOTTOM", "LEFT_CENTER", "LEFT_TOP")}}
  \item{css - a string of valid \code{css} for controlling the appearance of the legend}
  \item{title - a string to use for the title of the legend}
}
if \code{legend_options} are NULL, the default values will apply

If you are displaying two legends, one for \code{stroke_colour} and one
for \code{fill_colour}, you can specify different options for the different
colour attributes. See examples for \link{add_circles}.
}

\examples{
\dontrun{

map_key <- 'your_api_key'

google_map(key = map_key, data = tram_stops) \%>\%
 add_circles(lat = "stop_lat", lon = "stop_lon", fill_colour = "stop_name",
 stroke_weight = 0.3, stroke_colour = "stop_name", info_window ="stop_id")

## different colour palettes
lstPalette <- list(fill_colour = colorRampPalette(c("red","blue")),
    stroke_colour = viridisLite::plasma)

## set the key via set_key()
set_key(key = map_key)

google_map(data = tram_stops) \%>\%
 add_circles(lat = "stop_lat", lon = "stop_lon", fill_colour = "stop_lat",
 stroke_weight = 2, stroke_colour = "stop_name", palette = lstPalette, legend = T)

## controlling the legend
google_map(data = tram_stops) \%>\%
 add_circles(lat = "stop_lat", lon = "stop_lon", fill_colour = "stop_lat",
 stroke_weight = 2, stroke_colour = "stop_name",
 legend = c(fill_colour = T, stroke_colour = F),
 legend_options = list(position = "TOP_RIGHT", css = "max-height: 100px;"))

google_map(data = tram_stops) \%>\%
 add_circles(lat = "stop_lat", lon = "stop_lon", fill_colour = "stop_lat",
 stroke_weight = 2, stroke_colour = "stop_name",
 legend = T,
 legend_options = list(
   fill_colour = list(position = "TOP_RIGHT", css = "max-height: 100px;"),
   stroke_colour = list(position = "LEFT_BOTTOM", title = "Stop Name")
   ))


 }
}
