% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_register.R
\name{googlesheet}
\alias{googlesheet}
\alias{gs_gs}
\alias{gs_key}
\alias{gs_title}
\alias{gs_url}
\alias{gs_ws_feed}
\title{Register a Google Sheet}
\usage{
gs_title(x, verbose = TRUE)

gs_key(x, lookup = NULL, visibility = NULL, verbose = TRUE)

gs_url(x, lookup = NULL, visibility = NULL, verbose = TRUE)

gs_ws_feed(x, lookup = NULL, verbose = TRUE)

gs_gs(x, visibility = NULL, verbose = TRUE)
}
\arguments{
\item{x}{sheet-identifying information; a character vector of length one
holding sheet title, key, browser URL or worksheets feed OR, in the case of
\code{gs_gs} only, a \code{googlesheet} object}

\item{verbose}{logical; do you want informative messages?}

\item{lookup}{logical, optional. Controls whether \code{googlesheets} will
place authorized API requests during registration. If unspecified, will
be set to \code{TRUE} if authorization has previously been used in this R
session, if working directory contains a file named \code{.httr-oauth}, or
if \code{x} is a worksheets feed or \code{googlesheet} object that
specifies "public" visibility.}

\item{visibility}{character, either "public" or "private". Consulted during
explicit construction of a worksheets feed from a key, which happens only
when \code{lookup = FALSE} and \code{googlesheets} is prevented from
looking up information in the spreadsheets feed. If unspecified, will be
set to "public" if \code{lookup = FALSE} and "private" if \code{lookup =
TRUE}. Consult the API docs for more info about
\href{https://developers.google.com/google-apps/spreadsheets/worksheets#sheets_api_urls_visibilities_and_projections}{visibility}}
}
\value{
a \code{googlesheet} object
}
\description{
The \code{googlesheets} package must gather information on a Google Sheet
from \href{https://developers.google.com/google-apps/spreadsheets/}{the API}
prior to any requests to read or write data. We call this
\strong{registering} the sheet and store the result in a \code{googlesheet}
object. Note this object does not contain any sheet data, but rather contains
metadata about the sheet. We populate a \code{googlesheet}
object with information from the
\href{https://developers.google.com/google-apps/spreadsheets/worksheets}{worksheets
feed} and, if available, also from the
\href{https://developers.google.com/google-apps/spreadsheets/worksheets#retrieve_a_list_of_spreadsheets}{spreadsheets
feed}. Choose from the functions below depending on the type of
sheet-identifying input you will provide. Is it a sheet title, key,
browser URL, or worksheets feed (another URL, mostly used internally)?
}
\details{
A registered \code{googlesheet} will contain information on:

\itemize{
  \item \code{sheet_key} the key of the spreadsheet
  \item \code{sheet_title} the title of the spreadsheet
  \item \code{n_ws} the number of worksheets contained in the spreadsheet
  \item \code{ws_feed} the "worksheets feed" of the spreadsheet
  \item \code{updated} the time of last update (at time of registration)
  \item \code{reg_date} the time of registration
  \item \code{visibility} visibility of spreadsheet (Google's confusing
    vocabulary); actually, does not describe a property of spreadsheet
    itself but rather whether requests will be made with or without
    authorization
  \item \code{is_public} logical indicating visibility is "public" (meaning
    unauthenticated requests will be sent), as opposed to "private" (meaning
    authenticated requests will be sent)
  \item \code{author} the name of the owner
  \item \code{email} the email of the owner
  \item \code{links} data.frame of links specific to the spreadsheet
  \item \code{ws} a data.frame about the worksheets contained in the
  spreadsheet
}

A \code{googlesheet} object will contain this information from the
spreadsheets feed if it was available at the time of registration:

\itemize{
  \item \code{alt_key} alternate key; applies only to "old" sheets
}

Since the spreadsheets feed contains private user data, \code{googlesheets}
must be properly authorized to access it. So a \code{googlesheet} object will
only contain info from the spreadsheets feed if \code{lookup = TRUE}, which
directs us to look up sheet-identifying information in the spreadsheets feed.
}

