% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/containers.R
\name{gtm_containers_create}
\alias{gtm_containers_create}
\title{Creates a new container in an acount}
\usage{
gtm_containers_create(
  account_id,
  name,
  type = c("web", "iosSdk5", "androidSdk5", "amp"),
  domain_name = NULL,
  notes = NULL
)
}
\arguments{
\item{account_id}{Account Id}

\item{name}{Container Name}

\item{type}{Container Use Type}

\item{domain_name}{List of domain names associated with the Container.}

\item{notes}{Container Notes.}
}
\description{
This creates a new container in the specified account.
}
\examples{
\dontrun{
accountId <- 1234567
newName <- "My New Container"

container <- gtm_containers_create(accountId, newName, 'web')

}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/create}

Other container functions: 
\code{\link{gtm_containers_delete}()},
\code{\link{gtm_containers_get}()},
\code{\link{gtm_containers_list}()},
\code{\link{gtm_containers_update}()}
}
\concept{container functions}
