% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vms.R
\name{gce_vm}
\alias{gce_vm}
\title{Create or fetch a virtual machine}
\usage{
gce_vm(name, ..., project = gce_get_global_project(),
  zone = gce_get_global_zone(), open_webports = TRUE)
}
\arguments{
\item{name}{The name of the instance}

\item{...}{Arguments passed on to \code{gce_vm_create}
\describe{
  \item{image_project}{Project ID of where the image lies}
  \item{image}{Name of the image resource to return}
  \item{image_family}{Name of the image family to search for}
  \item{disk_source}{Specifies a valid URL to an existing Persistent Disk resource.}
  \item{network}{The name of the network interface}
  \item{externalIP}{An external IP you have previously reserved, leave NULL to have one assigned or \code{"none"} for no external access.}
  \item{project}{Project ID for this request}
  \item{zone}{The name of the zone for this request}
  \item{dry_run}{whether to just create the request JSON}
  \item{auth_email}{If it includes '@' then assume the email, otherwise an environment file var that includes the email}
  \item{disk_size_gb}{If not NULL, override default size of the boot disk (size in GB)}
  \item{use_beta}{If set to TRUE will use the beta version of the API. Should not be used for production purposes.}
  \item{acceleratorCount}{\code{[BETA]} Number of GPUs to add to instance}
  \item{acceleratorType}{\code{[BETA]} Name of GPU to add, see \link{gce_list_gpus}}
  \item{name}{The name of the resource, provided by the client when initially creating the resource}
  \item{canIpForward}{Allows this instance to send and receive packets with non-matching destination or source IPs}
  \item{description}{An optional description of this resource}
  \item{metadata}{A named list of metadata key/value pairs assigned to this instance}
  \item{scheduling}{Scheduling options for this instance, such as preemptible instances}
  \item{serviceAccounts}{A list of service accounts, with their specified scopes, authorized for this instance}
  \item{tags}{A list of tags to apply to this instance}
  \item{predefined_type}{A predefined machine type from \link{gce_list_machinetype}}
  \item{cpus}{If not defining \code{predefined_type}, the number of CPUs}
  \item{memory}{If not defining \code{predefined_type}, amount of memory}
}}

\item{project}{Project ID for this request}

\item{zone}{The name of the zone for this request}

\item{open_webports}{If TRUE, will open firewall ports 80 and 443 if not open already}
}
\value{
A \code{gce_instance} object
}
\description{
Pass in the instance name to fetch its object, or create the instance via \link{gce_vm_create}.
}
\details{
Will get or create the instance as specified.  Will wait for instance to be created if necessary.

Make sure the instance is big enough to handle what you need, 
  for instance the default \code{f1-micro} will hang the instance when trying to install large R libraries.
}
\section{Creation logic}{


You need these parameters defined to call the right function for creation.  Check the function definitions for more details. 

If the VM name exists but is not running, it start the VM and return the VM object

If the VM is running, it will return the VM object

If you specify the argument \code{template} it will call \link{gce_vm_template}

If you specify one of \code{file} or \code{cloud_init} it will call \link{gce_vm_container}

Otherwise it will call \link{gce_vm_create}
}

\examples{

\dontrun{

library(googleComputeEngineR)
## auto auth, project and zone pre-set
## list your VMs in the project/zone

the_list <- gce_list_instances()

## start an existing instance
vm <- gce_vm("markdev")

## for rstudio, you also need to specify a username and password to login
vm <- gce_vm(template = "rstudio",
             name = "rstudio-server",
             username = "mark", password = "mark1234")

## specify your own cloud-init file and pass it into gce_vm_container()
vm <- gce_vm(cloud_init = "example.yml",
             name = "test-container",
             predefined_type = "f1-micro")

## specify disk size at creation
vm <- gce_vm('my-image3', disk_size_gb = 20)


}

}
