% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubsub.R
\name{gcs_create_pubsub}
\alias{gcs_create_pubsub}
\title{Create a pub/sub notification for a bucket}
\usage{
gcs_create_pubsub(
  topic,
  project,
  bucket = gcs_get_global_bucket(),
  event_types = NULL
)
}
\arguments{
\item{topic}{The pub/sub topic name}

\item{project}{The project-id that has the pub/sub topic}

\item{bucket}{The bucket for notifications}

\item{event_types}{What events to activate, leave at default for all}
}
\description{
Add a notification configuration that sends notifications for all supported events.
}
\details{
Cloud Pub/Sub notifications allow you to track changes to your Cloud Storage objects.
As a minimum you wil need: the Cloud Pub/Sub API activated for the project;
sufficient permissions on the bucket you wish to monitor;
sufficient permissions on the project to receive notifications;
an existing pub/sub topic;
have given your service account at least \code{pubsub.publisher} permission.
}
\examples{

\dontrun{

project <- "myproject"
bucket <- "mybucket"

# get the email to give access
gcs_get_service_email(project)

# once email has access, create a new pub/sub topic for your bucket
gcs_create_pubsub("gcs_r", project, bucket)

}


}
\seealso{
\url{https://cloud.google.com/storage/docs/reporting-changes}

Other pubsub functions: 
\code{\link{gcs_delete_pubsub}()},
\code{\link{gcs_get_service_email}()},
\code{\link{gcs_list_pubsub}()}
}
\concept{pubsub functions}
