% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buckets.R
\name{gcs_create_bucket}
\alias{gcs_create_bucket}
\title{Create a new bucket}
\usage{
gcs_create_bucket(name, projectId, location = "US",
  storageClass = c("STANDARD", "NEARLINE", "DURABLE_REDUCED_AVAILABILITY"),
  predefinedAcl = c("authenticatedRead", "private", "projectPrivate",
  "publicRead", "publicReadWrite"),
  predefinedDefaultObjectAcl = c("authenticatedRead", "private",
  "projectPrivate", "publicRead", "publicReadWrite"), projection = c("noAcl",
  "full"))
}
\arguments{
\item{name}{Globally unique name of bucket to create}

\item{projectId}{A valid Google project id}

\item{location}{Location of bucket. See details}

\item{storageClass}{Type of bucket}

\item{predefinedAcl}{Apply predefined access controls to bucket}

\item{predefinedDefaultObjectAcl}{Apply predefined access controls to objects}

\item{projection}{Properties to return. Default noAcl omits acl properties}
}
\description{
Create a new bucket in your project
}
\details{
\href{https://cloud.google.com/storage/docs/bucket-locations}{See here for details on location options}

todo: acl, cors, lifecycle, logging, versioning, website
}
\seealso{
Other bucket functions: \code{\link{gcs_get_bucket}},
  \code{\link{gcs_list_buckets}},
  \code{\link{gcs_update_bucket}}
}

