% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docker.R
\name{cr_deploy_docker_trigger}
\alias{cr_deploy_docker_trigger}
\title{Deploy Docker build from a Git repo}
\usage{
cr_deploy_docker_trigger(
  repo,
  image,
  trigger_name = paste0("docker-", image),
  image_tag = c("latest", "$SHORT_SHA", "$BRANCH_NAME"),
  ...,
  substitutions = NULL,
  ignoredFiles = NULL,
  includedFiles = NULL,
  timeout = NULL,
  projectId_target = cr_project_get()
)
}
\arguments{
\item{repo}{The git repo holding the Dockerfile from \link{cr_buildtrigger_repo}}

\item{image}{The name of the image you want to build}

\item{trigger_name}{The trigger name}

\item{image_tag}{What to tag the build docker image}

\item{...}{
  Arguments passed on to \code{\link[=cr_buildstep_docker]{cr_buildstep_docker}}
  \describe{
    \item{\code{tag}}{The tag or tags to be attached to the pushed image - can use \code{Build} macros}
    \item{\code{location}}{Where the Dockerfile to build is in relation to \code{dir}}
    \item{\code{projectId}}{The projectId}
    \item{\code{dockerfile}}{Specify the name of the Dockerfile found at \code{location}}
    \item{\code{kaniko_cache}}{If TRUE will use kaniko cache for Docker builds.}
    \item{\code{build_args}}{additional arguments to pass to \code{docker build},
should be a character vector.}
    \item{\code{push_image}}{if \code{kaniko_cache = FALSE} and
\code{push_image = FALSE}, then the docker image is simply built and not
pushed}
  }}

\item{substitutions}{A named list of Build macro variables}

\item{ignoredFiles}{ignored_files and included_files are file glob matches extended with support for "**".}

\item{includedFiles}{If any of the files altered in the commit pass the ignored_files}

\item{timeout}{Timeout for build}

\item{projectId_target}{The project to publish the Docker image to.  The image will be built under the project configured via \link{cr_project_get}.  You will need to give the build project's service email access to the target GCP project via IAM for it to push successfully.}
}
\description{
This helps the common use case of building a Dockerfile based on the contents of a GitHub repo, and sets up a build trigger so it will build on every commit.
}
\details{
This creates a buildtrigger to do a kamiko cache enabled Docker build upon each commit, as defined by your repo settings via \link{cr_buildtrigger_repo}.  It will build all tags concurrently.
}
\examples{
\dontrun{
repo <- cr_buildtrigger_repo("MarkEdmondson1234/googleCloudRunner")
# create trigger that will publish Docker image to gcr.io/your-project/test upon each GitHub commit
cr_deploy_docker_trigger(repo, "test", dir = "cloud_build")

# build in one project, publish the docker image to another project (gcr.io/another-project/test)
cr_deploy_docker_trigger(repo, "test", projectId_target = "another-project", dir = "cloud_build")
}
}
\seealso{
\link{cr_deploy_docker} which lets you build Dockerfiles for more generic use cases

Other Deployment functions: 
\code{\link{cr_deploy_docker}()},
\code{\link{cr_deploy_packagetests}()},
\code{\link{cr_deploy_pkgdown}()},
\code{\link{cr_deploy_run_website}()},
\code{\link{cr_deploy_run}()},
\code{\link{cr_deploy_r}()}
}
\concept{Deployment functions}
