% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_sources.R
\name{cr_build_source}
\alias{cr_build_source}
\alias{cr_build_source.gar_RepoSource}
\alias{cr_build_source.gar_StorageSource}
\title{Build a source object}
\usage{
cr_build_source(x)

\method{cr_build_source}{gar_RepoSource}(x)

\method{cr_build_source}{gar_StorageSource}(x)
}
\arguments{
\item{x}{A \link{RepoSource} or a \link{StorageSource} object}
}
\description{
This creates a source object for a build.  Note you may instead want to use sources connected to a Build Trigger in which case see \link{cr_buildtrigger_repo}
}
\examples{

repo <- RepoSource("my_repo", branchName = "master")
gcs <- StorageSource("my_code.tar.gz", "gs://my-bucket")

cr_build_source(repo)
cr_build_source(gcs)

my_gcs_source <- cr_build_source(gcs)
my_repo_source <- cr_build_source(repo)
\dontrun{

build1 <- cr_build("cloudbuild.yaml", source = my_gcs_source)
build2 <- cr_build("cloudbuild.yaml", source = my_repo_source)
}

}
