% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_hazards_to_ex.R
\name{convert_hazards_to_ex}
\alias{convert_hazards_to_ex}
\title{Convert hazard ratios to life expectancy}
\usage{
convert_hazards_to_ex(
  df,
  age = 65,
  upper_age = 120,
  M = 80,
  b = 0.075,
  use_model_estimates = FALSE
)
}
\arguments{
\item{df}{Dataframe of results given by gompertz_mle() function}

\item{age}{Age at which to calculate remaining life expectancy}

\item{upper_age}{Maximal age to use in life table calculation}

\item{M}{Gompertz parameter modal age at death}

\item{b}{Gompertz mortality slope parameter}

\item{use_model_estimates}{Use estimates of the Gompertz Parameters from the model, rather than defaults}
}
\value{
A dataframe of hazards ratios and corresponding e(x) estimates and confidence intervals
}
\description{
Convert hazard ratios to differences in remaining life expectancy
at a given age (defaults to age 65)
}
\examples{
#model hazards as function of birthplace using bunmd_demo data
demo_dataset <- dplyr::filter(bunmd_demo, bpl_string \%in\% c("Poland", "England")) \%>\%
dplyr::sample_frac(0.5)

#run gompertz_mle()
bpl <- gompertz_mle(formula = death_age ~ bpl_string, left_trunc = 1988,
                    right_trunc = 2005, data = demo_dataset)

#convert to difference in life expectancy
convert_hazards_to_ex(df = bpl$results, use_model_estimates = FALSE)

}
