\name{gofPIOSRn}
\alias{gofPIOSRn}

\title{2 dimensional gof test based on the in-and-out-of-sample approach
}
\description{
\code{gofPIOSRn} tests a 2 dimensional dataset with the approximate PIOS test for a copula. The possible copulae are "gaussian", "t", "gumbel", "clayton" and "frank". The parameter estimation is performed with pseudo maximum likelihood method. In case the estimation fails, inversion of Kendall's tau is used.
}
\usage{
gofPIOSRn(copula, x, M = 1000, param = 0.5, param.est = T, df = 4, df.est = T, 
          margins = "ranks", execute.times.comp = T)
}
\arguments{
\item{copula}{
The copula to test for. Possible are the copulae \code{"gaussian"}, \code{"t"}, \code{"clayton"}, \code{"gumbel"} and \code{"frank"}.
}
 \item{x}{
A 2 dimensional matrix containing the residuals of the data.
}
  \item{M}{
Number of bootstrapping loops.
}
  \item{param}{
The parameter to be used.
}
\item{param.est}{
Shall be either \code{TRUE} or \code{FALSE}. \code{TRUE} means that \code{param} will be estimated with a maximum likelihood estimation.
}
\item{df}{
Degrees of freedom, if not meant to be estimated. Only necessary if tested for \code{"t"}-copula.
}
\item{df.est}{
Indicates if \code{df} shall be estimated. Has to be either \code{FALSE} or \code{TRUE}, where \code{TRUE} means that it will be estimated.
}
\item{margins}{
Specifies which estimation method shall be used in case that the input data are not in the range [0,1]. The default is \code{"ranks"}, which is the standard approach to convert data in such a case. Alternatively can the following distributions be specified: \code{"beta"}, \code{"cauchy"}, Chi-squared (\code{"chisq"}), \code{"f"}, \code{"gamma"}, Log normal (\code{"lnorm"}), Normal (\code{"norm"}), \code{"t"}, \code{"weibull"}, Exponential (\code{"exp"}).
}
\item{execute.times.comp}{
Logical. Defines if the time which the estimation most likely takes shall be computed. It'll be just given if \code{M} is at least 100.
}
}
\details{
The "Rn" test is introduced in Zhang et al. (2015). It is a information ratio statistic which is approximately equivalent to the "Tn" test, which is the PIOS test. Both test the \eqn{H_0}{H0} hypothesis
\deqn{H_0 : C_0 \in \mathcal{C}.}{H0 : C0 in Ccal.}
"Rn" is introduced because the "Tn" test has to estimate \eqn{n/m} parameters which can be computationally demanding. The test statistic of the "Tn" test is defined as
\deqn{T = \sum_{b=1}^B \sum_{i=1}^m [l\{U_i^b;\theta_n \} - l\{U_i^b;\theta_n^{-b} \}]}{T = sum(sum(l(U_i^b;theta_n ) - l(U_i^b;theta_n^(-b) ), i=1, ...,m ), b=1, ...,B)}

with the pseudo observations \eqn{U_{ij}}{U[ij]} for \eqn{i = 1, \dots,n}{i = 1, ...,n}; \eqn{j = 1, \dots,d}{j = 1, ...,d} and
\deqn{\theta_n = \arg \min_{\theta} \sum_{i=1}^n l(U_i; \theta)}{theta_n = arg max_theta sum(l(U_i; theta), i=1, ..., n)}
and
\deqn{\theta_n^{-b} = \arg \min_{\theta} \sum_{b^{'} \neq b}^B \sum_{i=1}^m l(U_i^{b^{'}}; \theta), b=1, \dots, B.}{theta_n^(-b) = arg max_theta sum(sum(l(U_i^(b^'); theta), i=1, ..., m), b^'=1, ..., B, b^' != b), b = 1, ..., B.}

By defining two information matrices
\deqn{S(\theta) = - E_0 [\frac{\partial^2}{\partial \theta \partial \theta^{\top}}l \{U_1; \theta \} ],}{S(theta) = E0 [d^2/d theta d theta^T l(U_1; theta)],}
\deqn{V(\theta) = - E_0 [\frac{\partial}{\partial \theta} l \{U_1; \theta \} l^{\top} \{U_1; \theta \} ]}{V(theta) = E0 [d/d theta l(U_1; theta) d/d theta l^T(U_1; theta)]}
where \eqn{S(\cdot)}{S(.)} represents the negative sensitivity matrix, \eqn{V(\cdot)}{V(.)} the variability matrix and \eqn{E_0}{E0} is the expectation under the true copula \eqn{C_0}{C0}. Under suitable regularity conditions, given in Zhang et al. (2015), holds then in probability, that
\deqn{T = tr\{S(\theta^{*})^{-1} - V(\theta^{*} \}}{T = tr{S(theta^*)^(-1) - V(theta^*)}}
as \eqn{n \rightarrow \infty.}{n -> infinity.}

The approximate p-value is computed by the formula
\deqn{p = \frac{1}{B} \sum_{b = 1}^B \mathbf{I}(|T_b| \geq T).}{p = 1/B sum(I(T[b] >= T, b= 1, ..., B)).}
For more details, see Zhang et al. (2015). The applied estimation method is the two-step pseudo maximum likelihood approach, see Genest and Rivest (1995).

}
\value{
A object of the \code{class} gofCOP with the components
\item{method}{a character which informs about the performed analysis}
\item{statistic}{value of the test statistic}
\item{p.value}{the approximate p-value}
}
\references{
Zhang, S., Okhrin, O., Zhou, Q., and Song, P.. Goodness-of-fit Test For Specification of Semiparametric Copula Dependence Models. \emph{under revision in Journal of Econometrics from 15.01.2014} \url{http://sfb649.wiwi.hu-berlin.de/papers/pdf/SFB649DP2013-041.pdf} \cr \cr
Genest, C., K. G. and Rivest, L.-P. (1995). A semiparametric estimation procedure of dependence
parameters in multivariate families of distributions. \emph{Biometrika, 82:534-552}
}
\examples{
data = cbind(rnorm(100), rnorm(100))

gofPIOSRn("gaussian", data, M = 20)
}
