% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.cumres}
\alias{plot.cumres}
\title{Plot cumulative residuals from a 'cumres' object}
\usage{
\method{plot}{cumres}(
  x,
  idx = seq_along(x$W),
  col = "purple",
  col.alpha = 0.3,
  legend = c("type1", "type2", "none"),
  xlab,
  ylab,
  vs = TRUE,
  ylim = NULL,
  title,
  ...
)
}
\arguments{
\item{x}{Object produced by the function \code{cumres}.}

\item{idx}{vector of numbers (or variable names) indicating which processes
from the \code{x} to plot.}

\item{col}{Color of the sample processes. By setting this parameter to "none"
or \code{NULL} no realizations will be drawn. The number of realizations is
determined by the \code{cumres}-object.}

\item{col.alpha}{Transparency-level of plotted sample processes}

\item{legend}{Type of legend where "type1" gives p-values of GoF-tests and
"type2" gives usual type of legends.}

\item{xlab}{Optional label of x-axis}

\item{ylab}{Optional label of y-axis}

\item{vs}{Label of predictor}

\item{ylim}{Range of y axis}

\item{title}{Main title}

\item{...}{Additional arguments passed to the plot-routine.}
}
\description{
\code{plot} displays the observed cumulative residual process with
realizations under the null.
}
\examples{

n <- 500; x <- abs(rnorm(n,sd=0.2))+0.01; y <- sqrt(x) + rnorm(n,sd=0.2)
l <- lm(y ~ x)
g <- cumres(l, R=500)
plot(g, idx=1, legend="type2")
}
\author{
Klaus K. Holst
}
\keyword{hplot}
\keyword{regression}
