% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{usamone_prec}
\alias{usamone_prec}
\title{U.S. data containing log-differences of industrial production index, consumer price index, and M1, and an interest rate
variable}
\format{
A numeric matrix of class \code{'ts'} with 731 rows and 4 columns with one time series in each column:
\describe{
  \item{IP:}{The log-difference multiplied by hundred, \url{https://fred.stlouisfed.org/series/INDPRO}}
  \item{CPI:}{The log-difference multiplied by hundred, \url{https://fred.stlouisfed.org/series/CPIAUCSL}}
  \item{M1:}{The log-difference multiplied by hundred, \url{https://fred.stlouisfed.org/series/M1SL}}
  \item{RATE:}{From 1959 February to 2008 August \url{https://fred.stlouisfed.org/series/FEDFUNDS} and
               from 2008 September onwards \url{https://www.atlantafed.org/cqer/research/wu-xia-shadow-federal-funds-rate}}
}
}
\source{
The Federal Reserve Bank of St. Louis database and the Federal Reserve Bank of Atlanta's website
}
\usage{
usamone_prec
}
\description{
A dataset containing the monthly U.S. data covering the period from February 1959 to December 2019
(731 observations) and consisting of four variables: the log-difference of industrial production index (IP),
the log-difference of consumer price index (CPI), the log-difference of M1 monetary aggregate (M1), and an interest rate
variable (RATE). The log-differences are multiplied by hundred. The interest rate variable is the effective
federal funds rate from February 1959 to August 2008 after which we replaced it with the Wu and Xia
(2016) shadow rate, which is not constrained by the zero lower bound and also
quantifies unconventional monetary policy measures.
}
\details{
The Wu and Xia (2016) shadow rate data was retrieved from the Federal Reserve Bank of Atlanta's website
 (\url{https://www.atlantafed.org/cqer/research/wu-xia-shadow-federal-funds-rate}) and the rest of the data was
 retrieved from the Federal Reserve Bank of St. Louis database.
}
\references{
\itemize{
   \item J.C. Wu and F.D. Xia. 2016. Measuring the Macroeconomic Impact of Monetary Policy at the Zero Lower Bound.
         \emph{Journal of Money, Credit and Banking}, 48(2-3): 253-291.
 }
}
\keyword{datasets}
