% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R, R/printMethods.R,
%   R/quantileResidualTests.R
\name{plot.qrtest}
\alias{plot.qrtest}
\alias{print.qrtest}
\alias{quantile_residual_tests}
\title{Quantile residual tests}
\usage{
\method{plot}{qrtest}(x, ...)

\method{print}{qrtest}(x, ..., digits = 3)

quantile_residual_tests(
  gmvar,
  lags_ac = c(1:2, 4, 8),
  lags_ch = lags_ac,
  nsimu = 1,
  print_res = TRUE
)
}
\arguments{
\item{x}{object of class \code{'qrtest'} generated by the function \code{quantile_residual_tests)}.}

\item{...}{currently not used.}

\item{digits}{the number of decimals to print}

\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{lags_ac}{a positive integer vector specifying the lags used to test autocorrelation.}

\item{lags_ch}{a positive integer vector specifying the lags used to test conditional heteroskedasticity.}

\item{nsimu}{to how many simulations should the covariance matrix Omega used in the qr-tests be based on?
If smaller than sample size, then the covariance matrix will be evaluated from the sample. Larger number
of simulations might improve the tests size properties but increase the computation time.}

\item{print_res}{should the test results be printed while computing the tests?}
}
\value{
Returns an object of class \code{'qrtest'} which has its own print method. The returned object
  is a list containing the quantile residual test results for normality, autocorrelation, and conditional
  heteroskedasticity. The autocorrelation and conditional heteroskedasticity results also contain the
  associated (vectorized) individual statistics divided by their standard errors
  (see \emph{Kalliovirta and Saikkonen 2010}, s.17-20) under the label \code{$ind_stats}.
}
\description{
\code{quantile_residual_tests} performs quantile residual tests described
 by \emph{Kalliovirta and Saikkonen 2010}, testing autocorrelation, conditional heteroskedasticity,
 and normality.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: Plot p-values of the autocorrelation and conditional
heteroskedasticity tests.

\item \code{print}: Print method for class 'qrtest'
}}

\examples{
\donttest{
## These are long running examples that use parallel computing!

# These examples use the data 'eurusd' which comes with the
# package, but in a scaled form.
data <- cbind(10*eurusd[,1], 100*eurusd[,2])
colnames(data) <- colnames(eurusd)

# GMVAR(1,2) model with default settings
fit12 <- fitGMVAR(data, p=1, M=2)
qrtests12 <- quantile_residual_tests(fit12)
qrtests12
plot(qrtests12)

# Structural GMVAR(1,2) model identified with sign
# constraints. The sign constraints (which fully identify
# the shocks) are in line with the reduced form model,
# so the test results are the same.
W_122 <- matrix(c(1, NA, -1, 1), nrow=2)
fit12s <- fitGMVAR(data, p=1, M=2, structural_pars=list(W=W_122),
  ncalls=10, seeds=1:10)
qrtests12s <- quantile_residual_tests(fit12s)
qrtests12s

# GMVAR(2,2) model with mean parametrization
fit22 <- fitGMVAR(data, p=2, M=2, parametrization="mean",
  ncalls=1, seeds=20)
qrtests22 <- quantile_residual_tests(fit22)
qrtests22

# GMVAR(2,2) model with autoregressive parameters restricted
# to be the same for all regimes
C_mat <- rbind(diag(2*2^2), diag(2*2^2))
fit22c <- fitGMVAR(data, p=2, M=2, constraints=C_mat, ncalls=12)
qrtests22c <- quantile_residual_tests(fit22c, lags_ac=c(1, 4),
                nsimu=10000, print_res=TRUE)
qrtests22c
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Kalliovirta L. and Saikkonen P. 2010. Reliable Residuals for Multivariate Nonlinear
         Time Series Models. \emph{Unpublished Revision of HECER Discussion Paper No. 247}.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{quantile_residuals}}, \code{\link{GIRF}},
  \code{\link{diagnostic_plot}}, \code{\link{predict.gmvar}}, \code{\link{profile_logliks}},
  \code{\link{LR_test}}, \code{\link{Wald_test}}
}
