% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_dropouts.R
\name{show_dropouts}
\alias{show_dropouts}
\title{Show participants who did not finish the experiment}
\usage{
show_dropouts(oTree, final_apps = NULL, final_pages = NULL, saved_vars = NULL)
}
\arguments{
\item{oTree}{A list of data frames that were created 
by \code{\link{import_otree}}.}

\item{final_apps}{Character.
The name(s) of the app(s) at which the participants have to finish the
experiment.}

\item{final_pages}{Character.
The name(s) of the page(s) at which the participants have to finish the
experiment.}

\item{saved_vars}{The name(s) of variable(s) that need(s) to be
shown in the list of information on dropout cases.}
}
\value{
This function returns a list of information on participants who did not
finish the experiment.

In this list, you can find the following information:

- \code{$full} = A data frame that contains information
on all participants who did not finish the study;
it shows their participant codes, the names of the apps in which they
left the experiment,
the names of the pages in which they left the experiment,
the names of the app data frames in which this information was found, and
the dropout reason (\code{"ENC"}, experiment not completed, combined
with the name of the data frame in which the dropout was observed).
Because participants usually appear in multiple app data frames,
the \code{$full} data frame may contain several entries for
each person.

- \code{$unique} = A data frame that contains similar information as 
the \code{$full} data frame but with only one row per participant and 
no information on the data frame in which the dropout was observed.

- \code{$all_end} = A table that provides information 
on the app and page combinations
where participants ended the experiment. This table also includes
information on participants who did not drop out of the experiment.
The \code{$all_end} table is only shown if an \code{$all_apps_wide} 
data frame exists.

- \code{$codes} = A vector containing the participant codes of
all participants who did not finish the experiment.

- \code{$count} = The number of all participants who did not 
finish the experiment.

It is important to note that if only the argument \code{final_pages} is set,
this function does not distinguish between page names that reoccur in
different apps.

If the columns \code{end_app} and \code{end_page} in the output are empty,
these variables were not saved by oTree for the specific participants.
This could be because empty rows were not deleted. This can be done
by using the argument \code{del_empty = TRUE}" when 
using \code{\link{import_otree}}.
}
\description{
Show information on the people who did not finish the experiment at (a)
certain page(s) and/or app(s).
}
\examples{
# Use package-internal list of oTree data frames
oTree <- gmoTree::oTree

# Show everyone who did not finish with the app "survey"
show_dropouts(oTree, final_apps = "survey")

# Show everyone who did not finish with the page "Demographics"
show_dropouts(oTree, final_pages = "Demographics")

# Show everyone who finished with the following apps: "survey," "dictator"
final_apps <- unique(oTree$all_apps_wide$participant._current_app_name)
final_apps <- final_apps[final_apps != "survey"]
final_apps <- final_apps[final_apps != "dictator"]
show_dropouts(oTree, final_apps = final_apps)
}
\keyword{oTree}
