% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ids.R
\name{make_ids}
\alias{make_ids}
\title{Make IDs}
\usage{
make_ids(
  oTree,
  gmake = FALSE,
  pmake = TRUE,
  from_app = "all_apps_wide",
  from_var = NULL,
  sstart = 1L,
  gstart = 1L,
  pstart = 1L,
  emptyrows = NULL,
  icw = FALSE
)
}
\arguments{
\item{oTree}{A list of data frames that were created 
by \code{\link{import_otree}}.}

\item{gmake}{Logical. \code{TRUE} if a variable 
called group_id should be made.
If from_var is not \code{NULL}, gmake is automatically set to \code{TRUE}.}

\item{pmake}{Logical. \code{TRUE} if a variable called \code{participant_id}
should be made.}

\item{from_app}{Character. Name of the data frame from which the session,
group, and participant information should be taken.
All normal app data frames and \code{$all_apps_wide} are allowed.}

\item{from_var}{Character. Name of the variable from which the group
information should be taken. This argument is only relevant
when \code{$all_apps_wide} is used as from_app and has group information 
that contradicts each other.}

\item{sstart}{Integer.
The number that serves as a starting point for session IDs.}

\item{gstart}{Integer.
The number that serves as a starting point for group IDs.}

\item{pstart}{Integer.
The number that serves as a starting point for participant IDs.}

\item{emptyrows}{Character. \code{"no"} if the function should stop if 
there are empty rows in from_app. \code{"yes"} if the function should 
continue to make IDs.}

\item{icw}{Logical. \code{TRUE} if the warning message should be
ignored that states that IDs cannot be made because of an oTree bug.}
}
\value{
ID variables are made in \code{$all_apps_wide}, all app data frames,
the \code{$Time} data frame, and the \code{$Chats} data frame.
See list of the additional ID variables in \code{$info$additional_variables}.
}
\description{
Make session IDs and, optionally, group IDs and participant IDs
that span across all data frames created by \code{\link{import_otree}}. 
Information for these IDs is taken from \code{$all_apps_wide}
but can be defined otherwise.

Note: Older versions of oTree may already contain a
variable called session_id in their \code{$Time} data frames.
This variable is overwritten by this function!

Important: Combine duplicate data before running this function!
}
\examples{
# Use package-internal list of oTree data frames
oTree <- gmoTree::oTree

# Make session IDs only
oTree2 <- make_ids(oTree)

# Show new variables
oTree2$all_apps_wide$session_id

# Make session IDs and group IDs
# Not working with this data set because group ID is not the same in all apps
\dontrun{
      oTree2 <- make_ids(oTree, gmake = TRUE)

      # Show new variables
      oTree2$all_apps_wide$session_id
      oTree2$all_apps_wide$group_id
}

# Get IDs from variable "dictator.1.group.id_in_subsession"
# in the data frame "all_apps_wide"
oTree2 <- make_ids(oTree,
                   gmake = TRUE,
                   from_var = "dictator.1.group.id_in_subsession")

# Show new variables
oTree2$all_apps_wide$session_id
oTree2$all_apps_wide$group_id

# Get IDs from another app than all_apps_wide
oTree2 <- make_ids(oTree, gmake = TRUE, from_app = "dictator")

# Show new variables
oTree2$all_apps_wide$session_id
oTree2$all_apps_wide$group_id
}
\keyword{oTree}
