% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmAnisotropy.R
\name{as.AnisotropyRangeMatrix}
\alias{as.AnisotropyRangeMatrix}
\alias{as.AnisotropyRangeMatrix.default}
\alias{as.AnisotropyRangeMatrix.AnisotropyRangeMatrix}
\title{Force a matrix to be anisotropy range matrix,}
\usage{
as.AnisotropyRangeMatrix(x)

\method{as.AnisotropyRangeMatrix}{default}(x)

\method{as.AnisotropyRangeMatrix}{AnisotropyRangeMatrix}(x)
}
\arguments{
\item{x}{matrix simmetric positive definite (i.e. M above)}
}
\value{
the same anisotropy, specified as \code{M}
}
\description{
Force a matrix M to be considered an anisotropy range matrix, i.e
with ranges and orientations,
such that \eqn{u = sqrt(h' * M^{-1} * h)} allows to use an isotropic
variogram.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default conversion to anisotropy range matrix

\item \code{AnisotropyRangeMatrix}: identity conversion
}}

\seealso{
Other anisotropy: 
\code{\link{AnisotropyRangeMatrix}()},
\code{\link{AnisotropyScaling}()},
\code{\link{anis_GSLIBpar2A}()},
\code{\link{as.AnisotropyScaling}()},
\code{\link{is.anisotropySpecification}()}
}
\concept{anisotropy}
