% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmSimulation.R
\name{gsi.DS}
\alias{gsi.DS}
\title{Workhorse function for direct sampling}
\usage{
gsi.DS(
  n,
  f,
  t,
  n_realiz,
  dim_TI,
  dim_SimGrid,
  TI_input,
  SimGrid_input,
  ivars_TI = 3:ncol(TI_input),
  SimGrid_mask = ncol(SimGrid_input),
  invertMask = TRUE
)
}
\arguments{
\item{n}{size of the conditioning data event (integer)}

\item{f}{fraction of the training image to scan (numeric between 0 and 1)}

\item{t}{maximal acceptable discrepance between conditioning data event and TI event (numeric between 0 and 1)}

\item{n_realiz}{number of simulations desired}

\item{dim_TI}{dimensions of the grid of the training image (ie. either \eqn{(n_x, n_y)}
for dimension \eqn{k=2} or \eqn{(n_x, n_y, n_z)} for dimension \eqn{k=3})}

\item{dim_SimGrid}{dimensions of the simulation grid (ie. either \eqn{(m_x, m_y)} or
\eqn{(m_x, m_y, m_z)})}

\item{TI_input}{training image, as a matrix of \eqn{(n_x\cdot n_y\cdot n_z, k+D)}
elements; WITH NAMED COLUMNS and including spatial coordinates}

\item{SimGrid_input}{simulation grid with conditioning data, as a matrix of
\eqn{(m_x\cdot m_y\cdot m_z, k+D)} elements; with same columns as \code{TI_input}}

\item{ivars_TI}{which colnames of \code{TI_input} and \code{SimGrid_input} identify variables to consider in the data event}

\item{SimGrid_mask}{either a logical vector of length \eqn{m_x\cdot m_y\cdot m_z}, or else a column name of \code{SimGrid_input}
giving a logical column}

\item{invertMask}{logical, does \code{SimGrid_mask} identify with TRUE the data OUTSIDE the simulation area?}
}
\value{
A \code{\link[sp:SpatialPixelsDataFrame]{sp::SpatialPixelsDataFrame()}} or  \code{\link[sp:SpatialGridDataFrame]{sp::SpatialGridDataFrame()}}, depending on whether the whole
grid is simulated. The '@data' slot of these objects contains a \code{\link[=DataFrameStack]{DataFrameStack()}} with the stacking dimension
running through the realisations. It is safer to use this functionality through the interface
\code{\link[=make.gmCompositionalMPSSpatialModel]{make.gmCompositionalMPSSpatialModel()}}, then request a direct simulation with \code{\link[=DSpars]{DSpars()}} and
finally run it with \code{\link[=predict.gmSpatialModel]{predict.gmSpatialModel()}}.
}
\description{
This function implements in R the direct sampling algorithm
}
\examples{
## training image:
x = 1:10
y = 1:7
xy_TI = expand.grid(x=x, y=y)
TI_input = cbind(xy_TI, t(apply(xy_TI, 1, function(x) c(sum(x), abs(x[2]-x[1]))+rnorm(2, sd=0.01))))
colnames(TI_input) = c("x", "y", "V1", "V2")
o1 = image_cokriged(TI_input, ivar="V1")
o2 = image_cokriged(TI_input, ivar="V2")
## simulation grid:
SimGrid = TI_input
SimGrid$mask = with(SimGrid, x==1 | x==10 | y==1 | y==7)
tk = SimGrid$mask
tk[sample(70, 50)] = TRUE 
SimGrid[tk,3:4]=NA
image_cokriged(SimGrid, ivar="V1", breaks=o1$breaks, col=o1$col)
image_cokriged(SimGrid, ivar="V2", breaks=o2$breaks, col=o2$col)
image_cokriged(SimGrid, ivar="mask", breaks=c(-0.0001, 0.5, 1.001))
res = gsi.DS(n=5, f=0.75, t=0.05, n_realiz=2, dim_TI=c(10,7),  dim_SimGrid=c(10,7), 
       TI_input=as.matrix(TI_input), SimGrid_input=as.matrix(SimGrid), 
       ivars_TI = c("V1", "V2"), SimGrid_mask="mask", invertMask=TRUE)
image_cokriged(cbind(xy_TI, getStackElement(res,1)), ivar="V1", breaks=o1$breaks, col=o1$col)
image_cokriged(cbind(xy_TI, getStackElement(res,2)), ivar="V1", breaks=o1$breaks, col=o1$col)
image_cokriged(cbind(xy_TI, getStackElement(res,1)), ivar="V2", breaks=o2$breaks, col=o2$col)
image_cokriged(cbind(xy_TI, getStackElement(res,2)), ivar="V2", breaks=o2$breaks, col=o2$col)
}
\author{
Hassan Talebi (copyright holder), Raimon Tolosana-Delgado
}
