% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm3.R
\name{gvif.overglm}
\alias{gvif.overglm}
\title{Generalized Variance Inflation Factor for alternatives to the Poisson and Binomial Regression Models under the presence of Overdispersion}
\usage{
\method{gvif}{overglm}(model, verbose = TRUE, ...)
}
\arguments{
\item{model}{an object of class \emph{overglm}.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A matrix with so many rows as effects in the model and the following columns:
\tabular{ll}{
\code{GVIF} \tab the values of GVIF,\cr
\tab \cr
\code{df}\tab the number of degrees of freedom,\cr
\tab \cr
\code{GVIF^(1/(2*df))}\tab the values of GVIF\eqn{^{1/2 df}},\cr
}
}
\description{
Computes the generalized variance inflation factor (GVIF) for regression models based on the negative binomial, beta-binomial, and
random-clumped binomial distributions, which are alternatives to the Poisson and binomial regression models under the presence of overdispersion.
The GVIF is aimed to identify collinearity problems.
}
\details{
If the number of degrees of freedom is 1 then the GVIF reduces to the Variance
Inflation Factor (VIF).
}
\examples{
###### Example 1: Self diagnozed ear infections in swimmers
data(swimmers)
fit1 <- overglm(infections ~ frequency + location, family="nb1(log)", data=swimmers)
gvif(fit1)

###### Example 2: Article production by graduate students in biochemistry PhD programs
bioChemists <- pscl::bioChemists
fit2 <- overglm(art ~ fem + kid5 + ment, family="nb1(log)", data = bioChemists)
gvif(fit2)

###### Example 3: Agents to stimulate cellular differentiation
data(cellular)
fit3 <- overglm(cbind(cells,200-cells) ~ tnf + ifn, family="bb(logit)", data=cellular)
gvif(fit3)

}
\references{
Fox J., Monette G. (1992) Generalized collinearity diagnostics, \emph{JASA} 87, 178–183.
}
\seealso{
\link{gvif.lm}, \link{gvif.glm}
}
