% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm3.R
\name{overtest}
\alias{overtest}
\title{Test for Overdispersion}
\usage{
overtest(object, verbose = TRUE)
}
\arguments{
\item{object}{an object of the class \code{overglm}.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}
}
\value{
A matrix with 1 row and the following columns:
\tabular{ll}{
\code{Chi} \tab the value of the likelihood-ratio statistic,\cr
\tab \cr
\code{df}\tab the degrees-of-freedom,\cr
\tab \cr
\code{Pr(>Chi)}\tab the p-value associated with the test,\cr
}
}
\description{
This function uses the likelihood-ratio test to assess if the negative binomial model fits the data better than the poisson model, that is, it uses the likelihood-ratio test to assess the null hypothesis given by \eqn{H_0: \phi=0} versus the alternative hypothesis given by \eqn{H_1: \phi>0}, where \eqn{\phi} represents the dispersion parameter of the negative binomial distribution. This function also uses the likelihood-ratio test to assess if the beta binomial or the random-clumped binomial models fits the data better than the binomial model.
}
\details{
The value of \eqn{\phi} specified at the null hypothesis is
the lower limit of its parametric space. Therefore, the p-value
associated with the test is computed as \eqn{\frac{1}{2}} if
\eqn{\xi=0} and \eqn{\frac{1}{2}*Pr[\chi^2(1)>\xi]} if
\eqn{\xi>0}, where \eqn{\xi} represents the likelihood-ratio
statistic.
}
\examples{
####### Example 1: Self diagnozed ear infections in swimmers
data(swimmers)
fit1 <- overglm(infections ~ frequency + location, family="nb1", data=swimmers)
overtest(fit1)

####### Example 2: Article production by graduate students in biochemistry PhD programs
bioChemists <- pscl::bioChemists
fit2 <- overglm(art ~ fem + kid5 + ment, family="ztnb1", data=bioChemists, subset={art > 0})
overtest(fit2)

####### Example 3: Agents to stimulate cellular differentiation
data(cellular)
fit3 <- overglm(cbind(cells,200-cells) ~ tnf + ifn, family="bb", data=cellular)
overtest(fit3)

}
\seealso{
\link{overglm}, \link{zero.excess}
}
