% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnetFlex.R
\name{spelnet.fit}
\alias{spelnet.fit}
\title{Solve weighted least squares (WLS) problem for a single lambda value}
\usage{
spelnet.fit(x, xm, xs, y, weights, lambda, alpha = 1, intercept = TRUE,
  thresh = 1e-07, maxit = 1e+05, penalty.factor = rep(1, nvars),
  exclude = c(), lower.limits = -Inf, upper.limits = Inf,
  warm = NULL, from.spglmnet.fit = FALSE, save.fit = FALSE)
}
\arguments{
\item{x}{Input matrix, of dimension \code{nobs x nvars}; each row is an
observation vector.}

\item{xm}{Vector of length \code{nvars}: \code{xm(j)} is the centering factor
for variable j.}

\item{xs}{Vector of length \code{nvars}: \code{xs(j)} is the scaling factor
for variable j.}

\item{y}{Quantitative response variable.}

\item{weights}{Observation weights. \code{spelnet.fit} does NOT standardize
these weights.}

\item{lambda}{A single value for the \code{lambda} hyperparameter.}

\item{alpha}{The elasticnet mixing parameter, with \eqn{0 \le \alpha \le 1}.
The penalty is defined as \deqn{(1-\alpha)/2||\beta||_2^2+\alpha||\beta||_1.}
\code{alpha=1} is the lasso penalty, and \code{alpha=0} the ridge penalty.}

\item{intercept}{Should intercept be fitted (default=TRUE) or set to zero (FALSE)?}

\item{thresh}{Convergence threshold for coordinate descent. Each inner
coordinate-descent loop continues until the maximum change in the objective
after any coefficient update is less than thresh times the null deviance.
Default value is \code{1e-7}.}

\item{maxit}{Maximum number of passes over the data; default is \code{10^5}.
(If a warm start object is provided, the number of passes the warm start object
performed is included.)}

\item{penalty.factor}{Separate penalty factors can be applied to each
coefficient. This is a number that multiplies \code{lambda} to allow differential
shrinkage. Can be 0 for some variables, which implies no shrinkage, and that
variable is always included in the model. Default is 1 for all variables (and
implicitly infinity for variables listed in exclude). Note: the penalty
factors are internally rescaled to sum to \code{nvars}.}

\item{exclude}{Indices of variables to be excluded from the model. Default is
none. Equivalent to an infinite penalty factor.}

\item{lower.limits}{Vector of lower limits for each coefficient; default
\code{-Inf}. Each of these must be non-positive. Can be presented as a single
value (which will then be replicated), else a vector of length \code{nvars}.}

\item{upper.limits}{Vector of upper limits for each coefficient; default
\code{Inf}. See \code{lower.limits}.}

\item{warm}{A \code{glmnetfit} object which can be used as a warm start.
Default is \code{NULL}, indicating no warm start. For internal use only.}

\item{from.spglmnet.fit}{Was \code{spelnet.fit()} called from \code{spglmnet.fit()}?
Default is FALSE.This has implications for computation of the penalty factors.}

\item{save.fit}{Return the warm start object? Default is FALSE.}
}
\value{
An object with class "glmnetfit" and "glmnet". The list returned has
the same keys as that of a \code{glmnet} object, except that it might have an
additional \code{warm_fit} key.
\item{a0}{Intercept value.}
\item{beta}{A \code{nvars x 1} matrix of coefficients, stored in sparse matrix
format.}
\item{df}{The number of nonzero coefficients.}
\item{dim}{Dimension of coefficient matrix.}
\item{lambda}{Lambda value used.}
\item{dev.ratio}{The fraction of (null) deviance explained. The deviance
calculations incorporate weights if present in the model. The deviance is
defined to be 2*(loglike_sat - loglike), where loglike_sat is the log-likelihood
for the saturated model (a model with a free parameter per observation).
Hence dev.ratio=1-dev/nulldev.}
\item{nulldev}{Null deviance (per observation). This is defined to be
2*(loglike_sat -loglike(Null)). The null model refers to the intercept model.}
\item{npasses}{Total passes over the data.}
\item{jerr}{Error flag, for warnings and errors (largely for internal
debugging).}
\item{offset}{Always FALSE, since offsets do not appear in the WLS problem.
Included for compability with glmnet output.}
\item{call}{The call that produced this object.}
\item{nobs}{Number of observations.}
\item{warm_fit}{If \code{save.fit=TRUE}, output of FORTRAN routine, used for
warm starts. For internal use only.}
}
\description{
Solves the weighted least squares (WLS) problem for a single lambda value. Internal
function that users should not call directly. This version should be called if
\code{x} is a sparse matrix.
}
\details{
WARNING: Users should not call \code{spelnet.fit} directly. Higher-level functions
in this package call \code{spelnet.fit} as a subroutine. If a warm start object
is provided, some of the other arguments in the function may be overriden.

\code{spelnet.fit} is essentially a wrapper around a FORTRAN subroutine which
minimizes

\deqn{1/2 \sum w_i (y_i - X_i^T \beta)^2 + \sum \lambda \gamma_j
[(1-\alpha)/2 \beta^2+\alpha|\beta|],}

over \eqn{\beta}, where \eqn{\gamma_j} is the relative penalty factor on the
jth variable. If \code{intercept = TRUE}, then the term in the first sum is
\eqn{w_i (y_i - \beta_0 - X_i^T \beta)^2}, and we are minimizing over both
\eqn{\beta_0} and \eqn{\beta}.

None of the inputs are standardized except for \code{penalty.factor}, which
is standardized so that they sum up to \code{nvars}.
}
