% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{p_value_contrast}
\alias{p_value_contrast}
\alias{p_value_contrast.glm}
\alias{p_value_contrast.default}
\title{Hypothesis tests on contrasts}
\usage{
p_value_contrast(
  model,
  contrast,
  alternative = c("two.sided", "less", "greater"),
  H0 = 0,
  method = NULL,
  ...
)

\method{p_value_contrast}{glm}(
  model,
  contrast,
  alternative = c("two.sided", "less", "greater"),
  H0 = 0,
  method = c("LRT", "Rao", "Chisq", "F", "Wald", "wald"),
  ...,
  debuglevel = 1,
  force = FALSE
)

\method{p_value_contrast}{default}(
  model,
  contrast,
  alternative = c("two.sided", "less", "greater"),
  H0 = 0,
  method = "Wald",
  ...,
  debuglevel = 0,
  force = FALSE
)
}
\arguments{
\item{model}{a fitted statistical model such as a glm or a coxph.}

\item{contrast}{numeric vector of the same length as the number of coefficients in the model; it describes the contrast \code{sum(contrast*fixcoef(model))}.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "two.sided" (default), "greater" or "less". You can specify just the initial letter.}

\item{H0}{numeric value; the value of the contrast under the null hypothesis.}

\item{method}{character string value; specification of the algorithm used (implementation dependent).
Suggested values are "Wald", "LRT", "Rao" and "exact" for, respectively, Wald's asymptotic normality and/or student test,
the Generalized Likelihood Ratio Test, Rao's score test and non-asymptotic exact tests. Other values may be allowed.}

\item{...}{Additional parameters that may be used by some implementations.}

\item{debuglevel}{integer value; set to 0 (default) to disable warnings, 1 to enable warnings and 2 to enable warnings and notes.}

\item{force}{logical; if TRUE, force computation of P-values in case of convergence problems.}
}
\value{
A single numeric value (vector of length 1) equal to the one-sided (for alternative="less" or "greater") or two-sided P-value
}
\description{
This S3 generic function allows the computation of P-values associated to
hypothesis tests of contrasts (i.e. linear combinations) of fixed-effects in a model.
The default implementation computes Wald's P-values with any model as long as it consistently implements \code{\link{fixcoef}}, \code{\link{vcov_fixcoef}} and \code{\link{df_for_wald}}.
It is also specialized for GLMs and negative binomial models (see \code{\link[MASS:glm.nb]{MASS::glm.nb}}) with Wald's, LRT and Rao's P-values and may be specialized with other models.
}
\details{
Every implementation MUST support specification of the alternative hypothesis
(alternative argument) and null hypothesis (H0 argument).
}
\section{Methods (by class)}{
\itemize{
\item \code{glm}: It supports Wald (method="Wald"),
Generalized Likelihood Ratio Tests (method="LRT") and Rao's score tests (method="Rao").
It works for \code{\link[stats:glm]{stats::glm}} models and negative binomial models (\code{\link[MASS:glm.nb]{MASS::glm.nb}}) with method="LRT" and method="Wald".

\item \code{default}: Supports Wald's test on a wide range of models, including \code{\link[stats:lm]{lm}}, \code{\link[stats:lm]{mlm}},
\code{\link[stats:glm]{stats::glm}}, \code{\link[MASS:glm.nb]{negbin}}, \code{\link[MASS:polr]{MASS::polr}},
\code{\link[MASS:rlm]{MASS::rlm}} (with normality assumptions, defeating the purpose of rlm), \code{\link[nlme:lme]{nlme::lme}}, 
\code{\link[nlme:gls]{nlme::gls}}, \code{\link[lme4:lmer]{lme4::lmer}}, \code{\link[lme4:glmer]{lme4::glmer}}, 
\code{\link[mgcv:gam]{mgcv::gam}}, \code{\link[gam:gam]{gam::gam}}, \code{\link[survival:coxph]{survival::coxph}}, 
\code{\link[survival:survreg]{survival::survreg}}, 
\code{\link[nnet:multinom]{nnet::multinom}}, \code{\link[stats:nls]{stats::nls}}.

It can be easily extended by implementing three generic functions:
\code{\link[glmglrt:fixcoef]{fixcoef}}, \code{\link[glmglrt:vcov_fixcoef]{vcov_fixcoef}} and \code{\link[glmglrt:df_for_wald]{df_for_wald}}.
If the implementations of \code{\link[stats:coef]{coef}}, \code{\link[stats:vcov]{vcov}} and \code{\link[stats:df.residual]{df.residual}} are consistent,
you do not have to implement \code{fixcoef}, \code{vcov_fixcoef} and \code{df_for_wald}.
}}

\examples{
data(mtcars)
model1 = glm(family="gaussian", data=mtcars, hp ~ 0+factor(gear))
# do cars with 5 gears have more horse power (hp) than cars with 4 gears ?
p_value_contrast(model1, c(0,-1,1), alternative="greater")

# now, we fit an equivalent model (same distribution and same predictions)
model2 = glm(family=gaussian(log), data=mtcars, hp ~ 0+factor(gear))

# do cars with 5 gears have at least twice the horse power than cars with 4 gears ?

# the following two tests are equivalent
p_value_contrast(model1, c(0,-1,0.5), alternative="greater", method="LRT", H0=0)
p_value_contrast(model2, c(0,-1,1), alternative="greater", method="LRT", H0=log(2))

# the following two tests are close but not equivalent
p_value_contrast(model1, c(0,-1,0.5), alternative="greater", method="Wald", H0=0)
p_value_contrast(model2, c(0,-1,1), alternative="greater", method="Wald", H0=log(2))
}
\seealso{
Other Wald-related functions: 
\code{\link{df_for_wald}()},
\code{\link{fixcoef}()},
\code{\link{vcov_fixcoef}()}

Other Contrast functions: 
\code{\link{confint_contrast}()},
\code{\link{estimate_confint_contrast}()},
\code{\link{estimate_contrast}()}
}
\concept{Contrast functions}
\concept{Wald-related functions}
