% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.gllvm.R
\name{summary.gllvm}
\alias{summary.gllvm}
\alias{print.summary.gllvm}
\title{Summarizing gllvm model fits}
\usage{
\method{summary}{gllvm}(
  object,
  by = "all",
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  dispersion = FALSE,
  spp.intercepts = FALSE,
  row.intercepts = FALSE,
  Lvcoefs = FALSE,
  rotate = TRUE,
  type = NULL,
  ...
)

\method{print}{summary.gllvm}(x, ...)
}
\arguments{
\item{object}{an object of class 'gllvm'}

\item{by}{By = "all" (default) will return a Wald statistics per predictor and LV if the ordination includes predictors, by = "terms" will return a multivariate Wald statistic per predictor (displayed at first LV), and by = "LV" will do the same but per dimension (displayed at first predictors).}

\item{digits}{the number of significant digits to use when printing}

\item{signif.stars}{If \code{TRUE}, significance stars are printed for each coefficient, defaults to \code{TRUE}}

\item{dispersion}{option to return dispersion parameters, defaults to \code{FALSE}}

\item{spp.intercepts}{option to return species intercepts, defaults to \code{FALSE}}

\item{row.intercepts}{option to return row intercepts, defaults to \code{FALSE}}

\item{Lvcoefs}{option to return species scores in the ordination, defaults to \code{FALSE}. Returns species optima for quadratic model.}

\item{rotate}{defaults to \code{TRUE}. If \code{TRUE} rotates the output of the latent variables to principal direction, so that it coincides with the ordiplot results. If both unconstrained and constrained latent variables are included, predictor slopes are not rotated.}

\item{type}{to match "type" in \code{\link{ordiplot.gllvm}}}

\item{...}{not used.}

\item{x}{a summary object}
}
\description{
A summary of the fitted 'gllvm' object, including function call, distribution family and model parameters.
}
\details{
Various options are available to include extra parameter estimates in the summary, which have been excluded by default, for readability.
}
\examples{
\dontrun{
## Load a dataset from the mvabund package
data(antTraits)
y <- as.matrix(antTraits$abund)
# Fit gllvm model
fit <- gllvm(y = y, family = poisson())
summary(fit)
}
}
\author{
Jenni Niku <jenni.m.e.niku@jyu.fi>, Bert van der Veen
}
