% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwgof.R
\name{plotcompare}
\alias{plotcompare}
\title{Compare Goodness-of-Fit Results Across Multiple Models}
\usage{
plotcompare(gof_list, criteria = "all", plot = TRUE, plot_type = "all", ...)
}
\arguments{
\item{gof_list}{A named list of gkwgof objects, where names are used as model identifiers.}

\item{criteria}{Character vector specifying which criteria to compare. Available options are:
"information" (for AIC, BIC, etc.), "distance" (for KS, CvM, AD, etc.),
"prediction" (for MAE, RMSE, etc.), "probability" (for P-P, Q-Q correlations),
or "all" for all criteria. Default is "all".}

\item{plot}{Logical; if TRUE, creates comparison plots. Default is TRUE.}

\item{plot_type}{Character string specifying the type of plot to create. Available options are:
"radar" for a radar chart (requires the fmsb package),
"bar" for bar charts, "table" for a formatted table,
or "all" for all plot types. Default is "all".}

\item{...}{Additional arguments to be passed to plotting functions.}
}
\value{
A list containing the comparison results and plots.
}
\description{
Creates a comparison of goodness-of-fit statistics and plots across multiple models
from the GKw family of distributions.
}
\examples{
\donttest{
# Generate sample data
set.seed(123)
data <- rkw(n = 200, alpha = 2.5, beta = 1.8)

# Fit multiple models
fit_kw <- gkwfit(data, family = "kw")
fit_beta <- gkwfit(data, family = "beta")
fit_gkw <- gkwfit(data, family = "gkw")

# Calculate goodness-of-fit statistics for each model
gof_kw <- gkwgof(fit_kw, print_summary = FALSE)
gof_beta <- gkwgof(fit_beta, print_summary = FALSE)
gof_gkw <- gkwgof(fit_gkw, print_summary = FALSE)

# Compare the models
comparison <- plotcompare(
  list(KW = gof_kw, Beta = gof_beta, GKW = gof_gkw),
  plot_type = "all"
)
}

}
