% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\docType{methods}
\name{meta}
\alias{meta}
\alias{meta.character}
\alias{meta.factor}
\alias{meta.logical}
\alias{meta.POSIXct}
\alias{meta.Date}
\alias{meta.data.frame}
\title{Optimize an Object for Storage as Plain Text and Add Metadata}
\usage{
meta(x, ...)

\method{meta}{character}(x, na = "NA", optimize = TRUE, ...)

\method{meta}{factor}(x, optimize = TRUE, na = "NA", index, strict = TRUE, ...)

\method{meta}{logical}(x, optimize = TRUE, ...)

\method{meta}{POSIXct}(x, optimize = TRUE, ...)

\method{meta}{Date}(x, optimize = TRUE, ...)

\method{meta}{data.frame}(
  x,
  optimize = TRUE,
  na = "NA",
  sorting,
  strict = TRUE,
  split_by = character(0),
  ...
)
}
\arguments{
\item{x}{the vector.}

\item{...}{further arguments to the methods.}

\item{na}{the string to use for missing values in the data.}

\item{optimize}{If \code{TRUE}, recode the data to get smaller text files.
If \code{FALSE}, \code{meta()} converts the data to character.
Defaults to \code{TRUE}.}

\item{index}{An optional named vector with existing factor indices.
The names must match the existing factor levels.
Unmatched levels from \code{x} will get new indices.}

\item{strict}{What to do when the metadata changes. \code{strict = FALSE}
overwrites the data and the metadata with a warning listing the changes,
\code{strict = TRUE} returns an error and leaves the data and metadata as is.
Defaults to \code{TRUE}.}

\item{sorting}{an optional vector of column names defining which columns to
use for sorting \code{x} and in what order to use them.
The default empty \code{sorting} yields a warning.
Add \code{sorting} to avoid this warning.
Strongly recommended in combination with version control.
See \code{vignette("efficiency", package = "git2rdata")} for an illustration of
the importance of sorting.}

\item{split_by}{An optional vector of variables name to split the text files.
This creates a separate file for every combination.
We prepend these variables to the vector of \code{sorting} variables.}
}
\value{
the optimized vector \code{x} with \code{meta} attribute.
}
\description{
Prepares a vector for storage. When relevant, \code{meta()} optimizes the object
for storage by changing the format to one which needs less characters. The
metadata stored in the \code{meta} attribute, contains all required information to
back-transform the optimized format into the original format.

In case of a data.frame, \code{meta()} applies itself to each of the columns. The
\code{meta} attribute becomes a named list containing the metadata for each column
plus an additional \code{..generic} element. \code{..generic} is a reserved name for
the metadata and not allowed as column name in a \code{data.frame}.

\code{write_vc()} uses this function to prepare a dataframe for storage.
Existing metadata is passed through the optional \code{old} argument. This
argument intended for internal use.
}
\note{
The default order of factor levels depends on the current locale.
See \code{\link{Comparison}} for more details on that.
The same code on a different locale might result in a different sorting.
\code{meta()} ignores, with a warning, any change in the order of factor levels.
Add \code{strict = FALSE} to enforce the new order of factor levels.
}
\examples{
meta(c(NA, "'NA'", '"NA"', "abc\tdef", "abc\ndef"))
meta(1:3)
meta(seq(1, 3, length = 4))
meta(factor(c("b", NA, "NA"), levels = c("NA", "b", "c")))
meta(factor(c("b", NA, "a"), levels = c("a", "b", "c")), optimize = FALSE)
meta(factor(c("b", NA, "a"), levels = c("a", "b", "c"), ordered = TRUE))
meta(
  factor(c("b", NA, "a"), levels = c("a", "b", "c"), ordered = TRUE),
  optimize = FALSE
)
meta(c(FALSE, NA, TRUE))
meta(c(FALSE, NA, TRUE), optimize = FALSE)
meta(complex(real = c(1, NA, 2), imaginary = c(3, NA, -1)))
meta(as.POSIXct("2019-02-01 10:59:59", tz = "CET"))
meta(as.POSIXct("2019-02-01 10:59:59", tz = "CET"), optimize = FALSE)
meta(as.Date("2019-02-01"))
meta(as.Date("2019-02-01"), optimize = FALSE)
}
\seealso{
Other internal: 
\code{\link{is_git2rdata}()},
\code{\link{is_git2rmeta}()},
\code{\link{print.git2rdata}()},
\code{\link{summary.git2rdata}()},
\code{\link{upgrade_data}()}
}
\concept{internal}
