% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/reference.r
\docType{methods}
\name{show,git_reference-method}
\alias{show,git_reference-method}
\alias{show,git_reference-methods}
\title{Brief summary of reference}
\usage{
\S4method{show}{git_reference}(object)
}
\arguments{
\item{object}{The reference \code{object}}
}
\value{
None (invisible 'NULL').
}
\description{
Brief summary of reference
}
\examples{
\dontrun{
## Create and initialize a repository in a temporary directory
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file, add and commit
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Brief summary of reference
references(repo)[[1]]
}
}
\keyword{methods}

