% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.R
\name{init}
\alias{init}
\title{Init a repository}
\usage{
init(path = ".", bare = FALSE)
}
\arguments{
\item{path}{A path to where to init a git repository}

\item{bare}{If TRUE, a Git repository without a working directory
is created at the pointed path. If FALSE, provided path will
be considered as the working directory into which the .git
directory will be created.}
}
\value{
A \code{git_repository} object
}
\description{
Init a repository
}
\examples{
\dontrun{
## Initialize a repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)
is_bare(repo)

## Initialize a bare repository
path_bare <- tempfile(pattern="git2r-")
dir.create(path_bare)
repo_bare <- init(path_bare, bare = TRUE)
is_bare(repo_bare)
}
}
\seealso{
\link{repository}
}
