% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tag.r
\docType{methods}
\name{show,git_tag-method}
\alias{show,git_tag-method}
\alias{show,git_tag-methods}
\title{Brief summary of a tag}
\usage{
\S4method{show}{git_tag}(object)
}
\arguments{
\item{object}{The tag \code{object}}
}
\value{
None (invisible 'NULL').
}
\description{
Brief summary of a tag
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Commit a text file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Create tag
tag(repo, "Tagname", "Tag message")

## View brief summary of tag
tags(repo)[[1]]
}
}
\keyword{methods}

