% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_data.R
\docType{data}
\name{gisco_coastallines}
\alias{gisco_coastallines}
\title{World coastal lines \code{POLYGON} object}
\format{
A \code{POLYGON} data frame (resolution: 1:20million, EPSG:4326)
 object with 8 variables:
\describe{
  \item{FID}{FID}
  \item{COAS_ID}{COAS_ID}
  \item{geometry}{geometry field}
}
}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/coas/geojson/COAS_RG_20M_2016_4326.geojson}{GISCO .geojson source}
}
\description{
A \code{sf} object as provided by GISCO (2016 version).
}
\examples{
 library(sf)

 coasts <- gisco_coastallines

 plot(
   st_geometry(coasts),
   xlim = c(100, 120),
   ylim = c(-24, 24),
   col = "grey90",
   border = "deepskyblue4",
   lwd = 2
 )
 box()
 title(
   main = "Coasts on Southeastern Asia",
   sub = gisco_attributions(),
   cex.sub = 0.7,
   line = 1
 )
}
\seealso{
\link{gisco_get_coastallines}
}
