% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_structure_constants.R
\name{get_structure_constants}
\alias{get_structure_constants}
\title{Get Structure Constants}
\usage{
get_structure_constants(perm)
}
\arguments{
\item{perm}{An object of a \code{gips_perm} class.
It can also be of a \code{gips} class, but
it will be interpreted as the underlying \code{gips_perm}.}
}
\value{
Returns a list of 5 items:
\code{r}, \code{d}, \code{k}, \code{L}, \code{dim_omega} - vectors of constants from
\href{https://arxiv.org/abs/2004.03503}{Theorem 1 from references}
and the beginning of
\href{https://arxiv.org/abs/2004.03503}{section 3.1. from references}.
}
\description{
Finds constants necessary for internal calculations of integrals and
eventually the posteriori probability in \code{\link[=log_posteriori_of_gips]{log_posteriori_of_gips()}}.
}
\details{
Uses \href{https://arxiv.org/abs/2004.03503}{Theorem 5 from references}
to calculate the constants.
}
\examples{
perm <- gips_perm("(1)(2)(3)(4,5)", 5)
get_structure_constants(perm)
}
\references{
Piotr Graczyk, Hideyuki Ishi, Bartosz Kołodziejek, Hélène Massam.
"Model selection in the space of Gaussian models invariant by symmetry."
The Annals of Statistics, 50(3) 1747-1774 June 2022.
\href{https://arxiv.org/abs/2004.03503}{arXiv link};
\doi{10.1214/22-AOS2174}
}
\seealso{
\itemize{
\item \code{\link[=calculate_gamma_function]{calculate_gamma_function()}}, \code{\link[=log_posteriori_of_gips]{log_posteriori_of_gips()}} - The functions
that rely heavily on \code{get_structure_constants()}.
}
}
